/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.crypto.cipher.CryptoCipher;

public final class ReflectionUtils {
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final ClassLoader CLASSLOADER;
    private static final Class<?> NEGATIVE_CACHE_SENTINEL;

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> klass, Object ... args2) {
        try {
            Constructor<T> ctor;
            if (args2.length == 0) {
                ctor = klass.getDeclaredConstructor(new Class[0]);
            } else {
                Class[] argClses = new Class[args2.length];
                for (int i = 0; i < args2.length; ++i) {
                    argClses[i] = args2[i].getClass();
                }
                ctor = klass.getDeclaredConstructor(argClses);
            }
            ctor.setAccessible(true);
            return ctor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = ReflectionUtils.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClassByNameOrNull(String name) {
        Map<String, WeakReference<Class<Object>>> map2;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map3 = CACHE_CLASSES;
        synchronized (map3) {
            map2 = CACHE_CLASSES.get(CLASSLOADER);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(CLASSLOADER, map2);
            }
        }
        Class<?> clazz2 = null;
        WeakReference<Class<Object>> ref2 = map2.get(name);
        if (ref2 != null) {
            clazz2 = (Class<?>)ref2.get();
        }
        if (clazz2 == null) {
            try {
                clazz2 = Class.forName(name, true, CLASSLOADER);
            }
            catch (ClassNotFoundException e) {
                map2.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map2.put(name, new WeakReference(clazz2));
            return clazz2;
        }
        if (clazz2 == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz2;
    }

    static {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        CLASSLOADER = threadClassLoader != null ? threadClassLoader : CryptoCipher.class.getClassLoader();
        NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

