/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.utils.IoUtils;

class OsCryptoRandom
extends Random
implements CryptoRandom {
    private static final long serialVersionUID = 6391500337172057900L;
    private static final int RESERVOIR_LENGTH = 8192;
    private transient FileInputStream stream;
    private final byte[] reservoir = new byte[8192];
    private int pos = this.reservoir.length;

    private void fillReservoir(int min2) {
        if (this.pos >= this.reservoir.length - min2) {
            try {
                IoUtils.readFully(this.stream, this.reservoir, 0, this.reservoir.length);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to fill reservoir", e);
            }
            this.pos = 0;
        }
    }

    public OsCryptoRandom(Properties props) {
        File randomDevFile = new File(props.getProperty("commons.crypto.secure.random.device.file.path", "/dev/urandom"));
        try {
            this.close();
            this.stream = new FileInputStream(randomDevFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.fillReservoir(0);
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized void nextBytes(byte[] bytes2) {
        int off = 0;
        int n = 0;
        while (off < bytes2.length) {
            this.fillReservoir(0);
            n = Math.min(bytes2.length - off, this.reservoir.length - this.pos);
            System.arraycopy(this.reservoir, this.pos, bytes2, off, n);
            off += n;
            this.pos += n;
        }
    }

    @Override
    protected synchronized int next(int nbits) {
        this.fillReservoir(4);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | this.reservoir[this.pos++] & 0xFF;
        }
        return n & -1 >> 32 - nbits;
    }

    @Override
    public synchronized void close() {
        if (this.stream != null) {
            IoUtils.cleanup(this.stream);
            this.stream = null;
        }
    }
}

