/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.JarMarker;
import org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.X000A_NTFS;
import org.apache.commons.compress.archivers.zip.X0014_X509Certificates;
import org.apache.commons.compress.archivers.zip.X0015_CertificateIdForFile;
import org.apache.commons.compress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import org.apache.commons.compress.archivers.zip.X0017_StrongEncryptionHeader;
import org.apache.commons.compress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final Map<ZipShort, Class<?>> implementations = new ConcurrentHashMap();

    public static void register(Class<?> c) {
        try {
            ZipExtraField ze = (ZipExtraField)c.newInstance();
            implementations.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(c + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(c + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(c + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class<?> c = implementations.get(headerId);
        if (c != null) {
            return (ZipExtraField)c.newInstance();
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        return ExtraFieldUtils.parse(data, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local2) throws ZipException {
        return ExtraFieldUtils.parse(data, local2, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local2, UnparseableExtraField onUnparseableData) throws ZipException {
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        block9: for (int start2 = 0; start2 <= data.length - 4; start2 += length + 4) {
            ZipShort headerId = new ZipShort(data, start2);
            length = new ZipShort(data, start2 + 2).getValue();
            if (start2 + 4 + length > data.length) {
                switch (onUnparseableData.getKey()) {
                    case 0: {
                        throw new ZipException("bad extra field starting at " + start2 + ".  Block length of " + length + " bytes exceeds remaining data of " + (data.length - start2 - 4) + " bytes.");
                    }
                    case 2: {
                        UnparseableExtraFieldData field = new UnparseableExtraFieldData();
                        if (local2) {
                            field.parseFromLocalFileData(data, start2, data.length - start2);
                        } else {
                            field.parseFromCentralDirectoryData(data, start2, data.length - start2);
                        }
                        v.add(field);
                    }
                    case 1: {
                        break block9;
                    }
                    default: {
                        throw new ZipException("unknown UnparseableExtraField key: " + onUnparseableData.getKey());
                    }
                }
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerId);
                try {
                    if (local2) {
                        ze.parseFromLocalFileData(data, start2 + 4, length);
                    } else {
                        ze.parseFromCentralDirectoryData(data, start2 + 4, length);
                    }
                }
                catch (ArrayIndexOutOfBoundsException aiobe) {
                    throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(headerId.getValue())).initCause(aiobe);
                }
                v.add(ze);
                continue;
            }
            catch (IllegalAccessException | InstantiationException ie) {
                throw (ZipException)new ZipException(ie.getMessage()).initCause(ie);
            }
        }
        ZipExtraField[] result2 = new ZipExtraField[v.size()];
        return v.toArray(result2);
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        byte[] local2;
        boolean lastIsUnparseableHolder = data.length > 0 && data[data.length - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? data.length - 1 : data.length;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getLocalFileDataLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data[i].getLocalFileDataLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] local3 = data[i].getLocalFileDataData();
            if (local3 == null) continue;
            System.arraycopy(local3, 0, result2, start2, local3.length);
            start2 += local3.length;
        }
        if (lastIsUnparseableHolder && (local2 = data[data.length - 1].getLocalFileDataData()) != null) {
            System.arraycopy(local2, 0, result2, start2, local2.length);
        }
        return result2;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        byte[] local2;
        boolean lastIsUnparseableHolder = data.length > 0 && data[data.length - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? data.length - 1 : data.length;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getCentralDirectoryLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data[i].getCentralDirectoryLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] local3 = data[i].getCentralDirectoryData();
            if (local3 == null) continue;
            System.arraycopy(local3, 0, result2, start2, local3.length);
            start2 += local3.length;
        }
        if (lastIsUnparseableHolder && (local2 = data[data.length - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(local2, 0, result2, start2, local2.length);
        }
        return result2;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(X5455_ExtendedTimestamp.class);
        ExtraFieldUtils.register(X7875_NewUnix.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
        ExtraFieldUtils.register(Zip64ExtendedInformationExtraField.class);
        ExtraFieldUtils.register(X000A_NTFS.class);
        ExtraFieldUtils.register(X0014_X509Certificates.class);
        ExtraFieldUtils.register(X0015_CertificateIdForFile.class);
        ExtraFieldUtils.register(X0016_CertificateIdForCentralDirectory.class);
        ExtraFieldUtils.register(X0017_StrongEncryptionHeader.class);
        ExtraFieldUtils.register(X0019_EncryptionRecipientCertificateList.class);
        ExtraFieldUtils.register(ResourceAlignmentExtraField.class);
    }

    public static final class UnparseableExtraField {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int k) {
            this.key = k;
        }

        public int getKey() {
            return this.key;
        }
    }
}

