/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;

public class CLI {
    public static void main(String[] args2) throws Exception {
        if (args2.length == 0) {
            CLI.usage();
            return;
        }
        Mode mode = CLI.grabMode(args2);
        System.out.println(mode.getMessage() + " " + args2[0]);
        File f2 = new File(args2[0]);
        if (!f2.isFile()) {
            System.err.println(f2 + " doesn't exist or is a directory");
        }
        try (SevenZFile archive2 = new SevenZFile(f2);){
            SevenZArchiveEntry ae;
            while ((ae = archive2.getNextEntry()) != null) {
                mode.takeAction(archive2, ae);
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [list|extract]");
    }

    private static Mode grabMode(String[] args2) {
        if (args2.length < 2) {
            return Mode.LIST;
        }
        return Enum.valueOf(Mode.class, args2[1].toUpperCase());
    }

    private static enum Mode {
        LIST("Analysing"){

            @Override
            public void takeAction(SevenZFile archive2, SevenZArchiveEntry entry2) {
                System.out.print(entry2.getName());
                if (entry2.isDirectory()) {
                    System.out.print(" dir");
                } else {
                    System.out.print(" " + entry2.getCompressedSize() + "/" + entry2.getSize());
                }
                if (entry2.getHasLastModifiedDate()) {
                    System.out.print(" " + entry2.getLastModifiedDate());
                } else {
                    System.out.print(" no last modified date");
                }
                if (!entry2.isDirectory()) {
                    System.out.println(" " + this.getContentMethods(entry2));
                } else {
                    System.out.println("");
                }
            }

            private String getContentMethods(SevenZArchiveEntry entry2) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (SevenZMethodConfiguration sevenZMethodConfiguration : entry2.getContentMethods()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append((Object)sevenZMethodConfiguration.getMethod());
                    if (sevenZMethodConfiguration.getOptions() == null) continue;
                    sb.append("(").append(sevenZMethodConfiguration.getOptions()).append(")");
                }
                return sb.toString();
            }
        }
        ,
        EXTRACT("Extracting"){
            private final byte[] buf = new byte[8192];

            @Override
            public void takeAction(SevenZFile archive2, SevenZArchiveEntry entry2) throws IOException {
                File outFile = new File(entry2.getName());
                if (entry2.isDirectory()) {
                    if (!outFile.isDirectory() && !outFile.mkdirs()) {
                        throw new IOException("Cannot create directory " + outFile);
                    }
                    System.out.println("created directory " + outFile);
                    return;
                }
                System.out.println("extracting to " + outFile);
                File parent = outFile.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Cannot create " + parent);
                }
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    int bytesRead;
                    long total2 = entry2.getSize();
                    for (long off = 0L; off < total2; off += (long)bytesRead) {
                        int toRead = (int)Math.min(total2 - off, (long)this.buf.length);
                        bytesRead = archive2.read(this.buf, 0, toRead);
                        if (bytesRead < 1) {
                            throw new IOException("reached end of entry " + entry2.getName() + " after " + off + " bytes, expected " + total2);
                        }
                        fos.write(this.buf, 0, bytesRead);
                    }
                }
            }
        };

        private final String message;

        private Mode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public abstract void takeAction(SevenZFile var1, SevenZArchiveEntry var2) throws IOException;
    }
}

