/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] args2) throws Exception {
        String format2;
        if (args2.length == 0) {
            Lister.usage();
            return;
        }
        System.out.println("Analysing " + args2[0]);
        File f2 = new File(args2[0]);
        if (!f2.isFile()) {
            System.err.println(f2 + " doesn't exist or is a directory");
        }
        String string2 = format2 = args2.length > 1 ? args2[1] : Lister.detectFormat(f2);
        if ("7z".equalsIgnoreCase(format2)) {
            Lister.list7z(f2);
        } else {
            Lister.listStream(f2, args2);
        }
    }

    private static void listStream(File f2, String[] args2) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f2.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = Lister.createArchiveInputStream(args2, fis);){
            ArchiveEntry ae;
            System.out.println("Created " + ais.toString());
            while ((ae = ais.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] args2, InputStream fis) throws ArchiveException {
        if (args2.length > 1) {
            return factory.createArchiveInputStream(args2[1], fis);
        }
        return factory.createArchiveInputStream(fis);
    }

    private static String detectFormat(File f2) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f2.toPath(), new OpenOption[0]));){
            String string2 = ArchiveStreamFactory.detect(fis);
            return string2;
        }
    }

    private static void list7z(File f2) throws ArchiveException, IOException {
        try (SevenZFile z = new SevenZFile(f2);){
            SevenZArchiveEntry ae;
            System.out.println("Created " + z.toString());
            while ((ae = z.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

