/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean wasInterrupted = Thread.interrupted();
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    wasInterrupted = true;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable2) {
            Object var7_8 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable2;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable2) {
            Object var6_7 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            throw throwable2;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success2 = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    if (nanos > 0L) {
                        long start2 = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        success2 = Utils.nanoTime() - start2 < nanos;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable2) {
            Object var13_12 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            throw throwable2;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
        return success2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success2 = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    long start2 = System.currentTimeMillis();
                    long msecs = abstime - start2;
                    if (msecs > 0L) {
                        this.wait(msecs);
                        success2 = System.currentTimeMillis() - start2 < msecs;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable2) {
            Object var13_12 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            throw throwable2;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
        return success2;
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

