/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private final long[] array;

    public AtomicLongArray(int length) {
        this.array = new long[length];
    }

    public AtomicLongArray(long[] array2) {
        if (array2 == null) {
            throw new NullPointerException();
        }
        int length = array2.length;
        this.array = new long[length];
        System.arraycopy(array2, 0, this.array, 0, array2.length);
    }

    public final int length() {
        return this.array.length;
    }

    public final synchronized long get(int i) {
        return this.array[i];
    }

    public final synchronized void set(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final synchronized void lazySet(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final synchronized long getAndSet(int i, long newValue) {
        long old = this.array[i];
        this.array[i] = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int i, long expect, long update2) {
        if (this.array[i] == expect) {
            this.array[i] = update2;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int i, long expect, long update2) {
        if (this.array[i] == expect) {
            this.array[i] = update2;
            return true;
        }
        return false;
    }

    public final synchronized long getAndIncrement(int i) {
        int n = i;
        long l = this.array[n];
        this.array[n] = l + 1L;
        return l;
    }

    public final synchronized long getAndDecrement(int i) {
        int n = i;
        long l = this.array[n];
        this.array[n] = l - 1L;
        return l;
    }

    public final synchronized long getAndAdd(int i, long delta) {
        long old = this.array[i];
        int n = i;
        this.array[n] = this.array[n] + delta;
        return old;
    }

    public final synchronized long incrementAndGet(int i) {
        int n = i;
        long l = this.array[n] + 1L;
        this.array[n] = l;
        return l;
    }

    public final synchronized long decrementAndGet(int i) {
        int n = i;
        long l = this.array[n] - 1L;
        this.array[n] = l;
        return l;
    }

    public synchronized long addAndGet(int i, long delta) {
        int n = i;
        long l = this.array[n] + delta;
        this.array[n] = l;
        return l;
    }

    public synchronized String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.array[0]);
        for (int i = 1; i < this.array.length; ++i) {
            buf.append(", ");
            buf.append(this.array[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

