/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private RunnableFuture newTaskFor(Callable task2) {
        if (this.aes == null) {
            return new FutureTask(task2);
        }
        return this.aes.newTaskFor(task2);
    }

    private RunnableFuture newTaskFor(Runnable task2, Object result2) {
        if (this.aes == null) {
            return new FutureTask(task2, result2);
        }
        return this.aes.newTaskFor(task2, result2);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    public Future submit(Callable task2) {
        if (task2 == null) {
            throw new NullPointerException();
        }
        RunnableFuture f2 = this.newTaskFor(task2);
        this.executor.execute(new QueueingFuture(f2));
        return f2;
    }

    public Future submit(Runnable task2, Object result2) {
        if (task2 == null) {
            throw new NullPointerException();
        }
        RunnableFuture f2 = this.newTaskFor(task2, result2);
        this.executor.execute(new QueueingFuture(f2));
        return f2;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Future)this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        QueueingFuture(RunnableFuture task2) {
            super(task2, null);
            this.task = task2;
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

