/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import [Ljava.lang.Object;;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CopyOnWriteArrayList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient Object[] array;

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection c) {
        Object[] array2 = c.toArray();
        if (array2.getClass() != Object;.class) {
            array2 = Arrays.copyOf(array2, array2.length, Object;.class);
        }
        this.setArray(array2);
    }

    public CopyOnWriteArrayList(Object[] array2) {
        this.setArray(Arrays.copyOf(array2, array2.length, Object;.class));
    }

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] array2) {
        this.array = array2;
    }

    public int size() {
        return this.getArray().length;
    }

    public boolean isEmpty() {
        return this.getArray().length == 0;
    }

    private static int search(Object[] array2, Object subject, int pos2, int end) {
        if (subject == null) {
            while (pos2 < end) {
                if (array2[pos2] == null) {
                    return pos2;
                }
                ++pos2;
            }
        } else {
            while (pos2 < end) {
                if (subject.equals(array2[pos2])) {
                    return pos2;
                }
                ++pos2;
            }
        }
        return -1;
    }

    private static int reverseSearch(Object[] array2, Object subject, int start2, int pos2) {
        if (subject == null) {
            --pos2;
            while (pos2 >= start2) {
                if (array2[pos2] == null) {
                    return pos2;
                }
                --pos2;
            }
        } else {
            --pos2;
            while (pos2 >= start2) {
                if (subject.equals(array2[pos2])) {
                    return pos2;
                }
                --pos2;
            }
        }
        return -1;
    }

    public boolean contains(Object o) {
        Object[] array2 = this.getArray();
        return CopyOnWriteArrayList.search(array2, o, 0, array2.length) >= 0;
    }

    public Iterator iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public Object[] toArray() {
        Object[] array2 = this.getArray();
        return Arrays.copyOf(array2, array2.length, Object;.class);
    }

    public Object[] toArray(Object[] a) {
        Object[] array2 = this.getArray();
        int length = array2.length;
        if (a.length < length) {
            return Arrays.copyOf(array2, length, a.getClass());
        }
        System.arraycopy(array2, 0, a, 0, length);
        if (a.length > length) {
            a[length] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object[] newarr = new Object[length + 1];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            newarr[length] = o;
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (CopyOnWriteArrayList.search(this.array, o, 0, length) >= 0) {
                return false;
            }
            Object[] newarr = new Object[length + 1];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            newarr[length] = o;
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection c) {
        Object[] arr = c.toArray();
        if (arr.length == 0) {
            return 0;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int oldlength = oldarr.length;
            Object[] tmp = new Object[arr.length];
            int added = 0;
            for (int i = 0; i < arr.length; ++i) {
                Object o = arr[i];
                if (CopyOnWriteArrayList.search(oldarr, o, 0, oldlength) >= 0 || CopyOnWriteArrayList.search(tmp, o, 0, added) >= 0) continue;
                tmp[added++] = o;
            }
            if (added == 0) {
                return 0;
            }
            Object[] newarr = new Object[oldlength + added];
            System.arraycopy(oldarr, 0, newarr, 0, oldlength);
            System.arraycopy(tmp, 0, newarr, oldlength, added);
            this.setArray(newarr);
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array2 = this.getArray();
            int length = array2.length;
            int pos2 = CopyOnWriteArrayList.search(array2, o, 0, length);
            if (pos2 < 0) {
                return false;
            }
            Object[] newarr = new Object[length - 1];
            int moved = length - pos2 - 1;
            if (pos2 > 0) {
                System.arraycopy(array2, 0, newarr, 0, pos2);
            }
            if (moved > 0) {
                System.arraycopy(array2, pos2 + 1, newarr, pos2, moved);
            }
            this.setArray(newarr);
            return true;
        }
    }

    public boolean containsAll(Collection c) {
        Object[] array2 = this.getArray();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (CopyOnWriteArrayList.search(array2, itr.next(), 0, array2.length) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Object[] ca = c.toArray();
        if (ca.length == 0) {
            return false;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object[] newarr = new Object[length + ca.length];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            int pos2 = length;
            System.arraycopy(ca, 0, newarr, pos2, ca.length);
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        Object[] ca = c.toArray();
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (index < 0 || index > length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            if (ca.length == 0) {
                return false;
            }
            Object[] newarr = new Object[length + ca.length];
            int moved = length - index;
            System.arraycopy(oldarr, 0, newarr, 0, index);
            int pos2 = length;
            System.arraycopy(ca, 0, newarr, index, ca.length);
            if (moved > 0) {
                System.arraycopy(oldarr, index, newarr, index + ca.length, moved);
            }
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array2 = this.getArray();
            int length = array2.length;
            Object[] tmp = new Object[length];
            int newlen = 0;
            for (int i = 0; i < length; ++i) {
                Object o = array2[i];
                if (c.contains(o)) continue;
                tmp[newlen++] = o;
            }
            if (newlen == length) {
                return false;
            }
            Object[] newarr = new Object[newlen];
            System.arraycopy(tmp, 0, newarr, 0, newlen);
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array2 = this.getArray();
            int length = array2.length;
            Object[] tmp = new Object[length];
            int newlen = 0;
            for (int i = 0; i < length; ++i) {
                Object o = array2[i];
                if (!c.contains(o)) continue;
                tmp[newlen++] = o;
            }
            if (newlen == length) {
                return false;
            }
            Object[] newarr = new Object[newlen];
            System.arraycopy(tmp, 0, newarr, 0, newlen);
            this.setArray(newarr);
            return true;
        }
    }

    public void clear() {
        this.setArray(new Object[0]);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator itr = ((List)o).listIterator();
        Object[] array2 = this.getArray();
        int length = array2.length;
        int idx = 0;
        while (idx < length && itr.hasNext()) {
            Object o1;
            Object o2 = itr.next();
            if (CopyOnWriteArrayList.eq(o1 = array2[idx++], o2)) continue;
            return false;
        }
        return idx == length && !itr.hasNext();
    }

    public int hashCode() {
        int hashCode2 = 1;
        Object[] array2 = this.getArray();
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            Object o = array2[i];
            hashCode2 = 31 * hashCode2 + (o == null ? 0 : o.hashCode());
        }
        return hashCode2;
    }

    public Object get(int index) {
        return this.getArray()[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object oldVal = oldarr[index];
            if (oldVal == element) {
                this.setArray(oldarr);
            } else {
                Object[] newarr = new Object[length];
                System.arraycopy(oldarr, 0, newarr, 0, length);
                newarr[index] = element;
                this.setArray(newarr);
            }
            return oldVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (index < 0 || index > length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            Object[] newarr = new Object[length + 1];
            int moved = length - index;
            System.arraycopy(oldarr, 0, newarr, 0, index);
            newarr[index] = element;
            if (moved > 0) {
                System.arraycopy(oldarr, index, newarr, index + 1, moved);
            }
            this.setArray(newarr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array2 = this.getArray();
            int length = array2.length;
            if (index < 0 || index >= length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            Object result2 = array2[index];
            Object[] newarr = new Object[length - 1];
            int moved = length - index - 1;
            if (index > 0) {
                System.arraycopy(array2, 0, newarr, 0, index);
            }
            if (moved > 0) {
                System.arraycopy(array2, index + 1, newarr, index, moved);
            }
            this.setArray(newarr);
            return result2;
        }
    }

    public int indexOf(Object o) {
        Object[] array2 = this.getArray();
        return CopyOnWriteArrayList.search(array2, o, 0, array2.length);
    }

    public int indexOf(Object o, int index) {
        Object[] array2 = this.getArray();
        return CopyOnWriteArrayList.search(array2, o, index, array2.length);
    }

    public int lastIndexOf(Object o) {
        Object[] array2 = this.getArray();
        return CopyOnWriteArrayList.reverseSearch(array2, o, 0, array2.length);
    }

    public int lastIndexOf(Object o, int index) {
        Object[] array2 = this.getArray();
        return CopyOnWriteArrayList.reverseSearch(array2, o, 0, index);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public ListIterator listIterator(int index) {
        Object[] array2 = this.getArray();
        if (index < 0 || index > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + array2.length);
        }
        return new COWIterator(array2, index);
    }

    public List subList(int fromIndex, int toIndex) {
        Object[] array2 = this.getArray();
        if (fromIndex < 0 || toIndex > array2.length || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(fromIndex, toIndex - fromIndex);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Object[] array2 = this.getArray();
        int length = array2.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeObject(array2[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        Object[] array2 = new Object[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = in.readObject();
        }
        this.setArray(array2);
    }

    public String toString() {
        Object[] array2 = this.getArray();
        int length = array2.length;
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(array2[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class COWSubIterator
    implements ListIterator {
        final Object[] array;
        int cursor;
        int first;
        int last;

        COWSubIterator(Object[] array2, int first, int last, int cursor) {
            this.array = array2;
            this.first = first;
            this.last = last;
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor < this.last;
        }

        public boolean hasPrevious() {
            return this.cursor > this.first;
        }

        public int nextIndex() {
            return this.cursor - this.first;
        }

        public Object next() {
            if (this.cursor == this.last) {
                throw new NoSuchElementException();
            }
            return this.array[this.cursor++];
        }

        public int previousIndex() {
            return this.cursor - this.first - 1;
        }

        public Object previous() {
            if (this.cursor == this.first) {
                throw new NoSuchElementException();
            }
            return this.array[--this.cursor];
        }

        public void add(Object val) {
            throw new UnsupportedOperationException();
        }

        public void set(Object val) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class COWSubList
    implements Serializable,
    List {
        private static final long serialVersionUID = -8660955369431018984L;
        final int offset;
        int length;
        transient Object[] expectedArray;

        COWSubList(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.expectedArray = CopyOnWriteArrayList.this.getArray();
        }

        public int size() {
            return this.length;
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public boolean contains(Object o) {
            return CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length) >= 0;
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public Object[] toArray() {
            Object[] array2 = CopyOnWriteArrayList.this.getArray();
            Object[] newarr = new Object[this.length];
            System.arraycopy(array2, this.offset, newarr, 0, this.length);
            return newarr;
        }

        public Object[] toArray(Object[] a) {
            Object[] array2 = CopyOnWriteArrayList.this.getArray();
            if (a.length < this.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                System.arraycopy(array2, this.offset, a, 0, this.length);
            } else {
                System.arraycopy(array2, this.offset, a, 0, this.length);
                if (a.length > this.length) {
                    a[this.length] = null;
                }
            }
            return a;
        }

        public boolean add(Object o) {
            this.add(this.length, o);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array2.length;
                int pos2 = CopyOnWriteArrayList.search(array2, o, this.offset, this.length);
                if (pos2 < 0) {
                    return false;
                }
                Object[] newarr = new Object[fullLength - 1];
                int moved = this.length - pos2 - 1;
                if (pos2 > 0) {
                    System.arraycopy(array2, 0, newarr, 0, pos2);
                }
                if (moved > 0) {
                    System.arraycopy(array2, pos2 + 1, newarr, pos2, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                --this.length;
                return true;
            }
        }

        public boolean containsAll(Collection c) {
            Object[] array2 = CopyOnWriteArrayList.this.getArray();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                if (CopyOnWriteArrayList.search(array2, itr.next(), this.offset, this.length) >= 0) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection c) {
            return this.addAll(this.length, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            int added = c.size();
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                int pos2;
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                if (added == 0) {
                    return false;
                }
                int fullLength = oldarr.length;
                Object[] newarr = new Object[fullLength + added];
                int newpos = pos2 = this.offset + index;
                System.arraycopy(oldarr, 0, newarr, 0, pos2);
                int rem = fullLength - pos2;
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    newarr[newpos++] = itr.next();
                }
                if (rem > 0) {
                    System.arraycopy(oldarr, pos2, newarr, newpos, rem);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length += added;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            if (c.isEmpty()) {
                return false;
            }
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array2.length;
                Object[] tmp = new Object[this.length];
                int retained = 0;
                for (int i = this.offset; i < this.offset + this.length; ++i) {
                    Object o = array2[i];
                    if (c.contains(o)) continue;
                    tmp[retained++] = o;
                }
                if (retained == this.length) {
                    return false;
                }
                Object[] newarr = new Object[fullLength + retained - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array2, 0, newarr, 0, this.offset);
                }
                if (retained > 0) {
                    System.arraycopy(tmp, 0, newarr, this.offset, retained);
                }
                if (moved > 0) {
                    System.arraycopy(array2, this.offset + this.length, newarr, this.offset + retained, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = retained;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array2.length;
                Object[] tmp = new Object[this.length];
                int retained = 0;
                for (int i = this.offset; i < this.offset + this.length; ++i) {
                    Object o = array2[i];
                    if (!c.contains(o)) continue;
                    tmp[retained++] = o;
                }
                if (retained == this.length) {
                    return false;
                }
                Object[] newarr = new Object[fullLength + retained - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array2, 0, newarr, 0, this.offset);
                }
                if (retained > 0) {
                    System.arraycopy(tmp, 0, newarr, this.offset, retained);
                }
                if (moved > 0) {
                    System.arraycopy(array2, this.offset + this.length, newarr, this.offset + retained, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = retained;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array2.length;
                Object[] newarr = new Object[fullLength - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array2, 0, newarr, 0, this.offset);
                }
                if (moved > 0) {
                    System.arraycopy(array2, this.offset + this.length, newarr, this.offset, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            int last;
            Object[] array2;
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            ListIterator itr = ((List)o).listIterator();
            int idx = this.offset;
            while (idx < last && itr.hasNext()) {
                Object o1 = array2[idx];
                Object o2 = itr.next();
                if (CopyOnWriteArrayList.eq(o1, o2)) continue;
                return false;
            }
            return idx == last && !itr.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            int last;
            Object[] array2;
            int hashCode2 = 1;
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            for (int i = this.offset; i < last; ++i) {
                Object o = array2[i];
                hashCode2 = 31 * hashCode2 + (o == null ? 0 : o.hashCode());
            }
            return hashCode2;
        }

        public Object get(int index) {
            return CopyOnWriteArrayList.this.getArray()[this.offset + index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = oldarr.length;
                Object oldVal = oldarr[this.offset + index];
                if (oldVal == element) {
                    CopyOnWriteArrayList.this.setArray(oldarr);
                } else {
                    Object[] newarr = new Object[fullLength];
                    System.arraycopy(oldarr, 0, newarr, 0, fullLength);
                    newarr[this.offset + index] = element;
                    CopyOnWriteArrayList.this.setArray(newarr);
                    this.expectedArray = newarr;
                }
                return oldVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index > this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = oldarr.length;
                Object[] newarr = new Object[fullLength + 1];
                int pos2 = this.offset + index;
                int moved = fullLength - pos2;
                System.arraycopy(oldarr, 0, newarr, 0, pos2);
                newarr[pos2] = element;
                if (moved > 0) {
                    System.arraycopy(oldarr, pos2, newarr, pos2 + 1, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                ++this.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array2.length;
                int pos2 = this.offset + index;
                Object result2 = array2[pos2];
                Object[] newarr = new Object[fullLength - 1];
                int moved = fullLength - pos2 - 1;
                if (index > 0) {
                    System.arraycopy(array2, 0, newarr, 0, pos2);
                }
                if (moved > 0) {
                    System.arraycopy(array2, pos2 + 1, newarr, pos2, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                --this.length;
                return result2;
            }
        }

        public int indexOf(Object o) {
            int pos2 = CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length);
            return pos2 >= 0 ? pos2 - this.offset : -1;
        }

        public int indexOf(Object o, int index) {
            int pos2 = CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset + index, this.offset + this.length) - this.offset;
            return pos2 >= 0 ? pos2 - this.offset : -1;
        }

        public int lastIndexOf(Object o) {
            int pos2 = CopyOnWriteArrayList.reverseSearch(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length) - this.offset;
            return pos2 >= 0 ? pos2 - this.offset : -1;
        }

        public int lastIndexOf(Object o, int index) {
            int pos2 = CopyOnWriteArrayList.reverseSearch(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + index) - this.offset;
            return pos2 >= 0 ? pos2 - this.offset : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                return new COWSubIterator(array2, this.offset, this.offset + this.length, this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                return new COWSubIterator(array2, this.offset, this.offset + this.length, this.offset + index);
            }
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.length || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new COWSubList(this.offset + fromIndex, toIndex - fromIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            int last;
            Object[] array2;
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array2 = CopyOnWriteArrayList.this.getArray();
                if (array2 != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            for (int i = this.offset; i < last; ++i) {
                if (i > this.offset) {
                    buf.append(", ");
                }
                buf.append(array2[i]);
            }
            buf.append(']');
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream out) throws IOException {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
            }
            out.defaultWriteObject();
            copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }
    }

    static class COWIterator
    implements ListIterator {
        final Object[] array;
        int cursor;

        COWIterator(Object[] array2, int cursor) {
            this.array = array2;
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException e) {
                --this.cursor;
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                ++this.cursor;
                throw new NoSuchElementException();
            }
        }

        public void add(Object val) {
            throw new UnsupportedOperationException();
        }

        public void set(Object val) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

