/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractCollection;
import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.AbstractSet;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set keySet;
    transient Set entrySet;
    transient Collection values;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash2) {
        return this.segments[hash2 >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m);
    }

    public boolean isEmpty() {
        int i;
        Segment[] segments2 = this.segments;
        int[] mc = new int[segments2.length];
        int mcsum = 0;
        for (i = 0; i < segments2.length; ++i) {
            if (segments2[i].count != 0) {
                return false;
            }
            mc[i] = segments2[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments2.length; ++i) {
                if (segments2[i].count == 0 && mc[i] == segments2[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments2 = this.segments;
        long sum = 0L;
        long check2 = 0L;
        int[] mc = new int[segments2.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check2 = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments2.length; ++i) {
                sum += (long)segments2[i].count;
                mc[i] = segments2[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments2.length; ++i) {
                    check2 += (long)segments2[i].count;
                    if (mc[i] == segments2[i].modCount) continue;
                    check2 = -1L;
                    break;
                }
            }
            if (check2 == sum) break;
        }
        if (check2 != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments2.length; ++i) {
                segments2[i].lock();
            }
            for (i = 0; i < segments2.length; ++i) {
                sum += (long)segments2[i].count;
            }
            for (i = 0; i < segments2.length; ++i) {
                segments2[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public Object get(Object key) {
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).get(key, hash2);
    }

    public boolean containsKey(Object key) {
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).containsKey(key, hash2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        Segment[] segments2 = this.segments;
        int[] mc = new int[segments2.length];
        for (int k = 0; k < 2; ++k) {
            boolean sum = false;
            int mcsum = 0;
            for (int i = 0; i < segments2.length; ++i) {
                int c = segments2[i].count;
                mc[i] = segments2[i].modCount;
                mcsum += mc[i];
                if (!segments2[i].containsValue(value2)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments2.length; ++i) {
                    int c = segments2[i].count;
                    if (mc[i] == segments2[i].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i = 0; i < segments2.length; ++i) {
            segments2[i].lock();
        }
        boolean found = false;
        try {
            for (int i = 0; i < segments2.length; ++i) {
                if (!segments2[i].containsValue(value2)) continue;
                found = true;
                break;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable2) {
            Object var11_11 = null;
            for (int i = 0; i < segments2.length; ++i) {
                segments2[i].unlock();
            }
            throw throwable2;
        }
        for (int i = 0; i < segments2.length; ++i) {
            segments2[i].unlock();
        }
        return found;
    }

    public boolean contains(Object value2) {
        return this.containsValue(value2);
    }

    public Object put(Object key, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).put(key, hash2, value2, false);
    }

    public Object putIfAbsent(Object key, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).put(key, hash2, value2, true);
    }

    public void putAll(Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).remove(key, hash2, null);
    }

    public boolean remove(Object key, Object value2) {
        if (value2 == null) {
            return false;
        }
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).remove(key, hash2, value2) != null;
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).replace(key, hash2, oldValue, newValue);
    }

    public Object replace(Object key, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash2).replace(key, hash2, value2);
    }

    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment seg = this.segments[k];
            seg.lock();
            try {
                HashEntry[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashEntry e = tab[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashEntry[1]);
        }
        while (true) {
            Object key = s.readObject();
            Object value2 = s.readObject();
            if (key == null) break;
            this.put(key, value2);
        }
    }

    final class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return ConcurrentHashMap.this.remove(o) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator {
        EntryIterator() {
        }

        public Object next() {
            HashEntry e = super.nextEntry();
            return new WriteThroughEntry(e.key, e.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry {
        WriteThroughEntry(Object k, Object v) {
            super(k, v);
        }

        public Object setValue(Object value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value2);
            ConcurrentHashMap.this.put(this.getKey(), value2);
            return v;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        ValueIterator() {
        }

        public Object next() {
            return super.nextEntry().value;
        }

        public Object nextElement() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        KeyIterator() {
        }

        public Object next() {
            return super.nextEntry().key;
        }

        public Object nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry getFirst(int hash2) {
            HashEntry[] tab = this.table;
            return tab[hash2 & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object readValueUnderLock(HashEntry e) {
            this.lock();
            try {
                Object object = e.value;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        Object get(Object key, int hash2) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash2);
                while (e != null) {
                    if (e.hash == hash2 && key.equals(e.key)) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        boolean containsKey(Object key, int hash2) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash2);
                while (e != null) {
                    if (e.hash == hash2 && key.equals(e.key)) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value2) {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                int len = tab.length;
                for (int i = 0; i < len; ++i) {
                    HashEntry e = tab[i];
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value2.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(Object key, int hash2, Object oldValue, Object newValue) {
            this.lock();
            try {
                HashEntry e = this.getFirst(hash2);
                while (!(e == null || e.hash == hash2 && key.equals(e.key))) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object replace(Object key, int hash2, Object newValue) {
            this.lock();
            try {
                HashEntry e = this.getFirst(hash2);
                while (!(e == null || e.hash == hash2 && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object put(Object key, int hash2, Object value2, boolean onlyIfAbsent) {
            this.lock();
            try {
                Object oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash2 & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash2 && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value2;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry(key, hash2, first, value2);
                    this.count = c;
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next2;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object remove(Object key, int hash2, Object value2) {
            this.lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash2 & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash2 && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value2 == null || value2.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry p = first;
                        while (p != e) {
                            newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry next;

        HashEntry(Object key, int hash2, HashEntry next2, Object value2) {
            this.key = key;
            this.hash = hash2;
            this.next = next2;
            this.value = value2;
        }

        static final HashEntry[] newArray(int i) {
            return new HashEntry[i];
        }
    }
}

