/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.zinc;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGServer;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.Compiler$;
import com.typesafe.zinc.Main$;
import com.typesafe.zinc.Nailgun;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.Setup$;
import com.typesafe.zinc.Setup$Defaults$;
import com.typesafe.zinc.Util;
import com.typesafe.zinc.Util$;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import sbt.Path$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Nailgun$ {
    public static final Nailgun$ MODULE$;
    private final int DefaultPort;
    private final int DefaultTimeout;
    private Util.Alarm shutdownTimer;

    static {
        new Nailgun$();
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public int DefaultTimeout() {
        return this.DefaultTimeout;
    }

    public void main(String[] args2) {
        long l;
        InetAddress inetAddress;
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(args2[0])).toInt();
        }
        catch (Exception exception) {
            n = this.DefaultPort();
        }
        int port = n;
        try {
            inetAddress = InetAddress.getByName(args2[2]);
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        InetAddress server = inetAddress;
        try {
            l = Util$.MODULE$.duration(args2[1], this.DefaultTimeout());
        }
        catch (Exception exception) {
            l = this.DefaultTimeout();
        }
        long timeout = l;
        this.start(server, port, timeout);
    }

    public void fork(Seq<String> options2, Seq<File> classpath, int port, String timeout) {
        Seq classpathOpts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-classpath", Path$.MODULE$.makeString(classpath)}));
        Seq mainOpts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Nailgun.class.getName(), ((Object)BoxesRunTime.boxToInteger((int)port)).toString(), timeout}));
        Seq cmd = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java"}))).$plus$plus(this.addDefaultOptions(options2), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)classpathOpts, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)mainOpts, Seq$.MODULE$.canBuildFrom());
        Runtime.getRuntime().exec((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public int fork$default$3() {
        return this.DefaultPort();
    }

    public String fork$default$4() {
        return "0";
    }

    public Seq<String> addDefaultOptions(Seq<String> options2) {
        ObjectRef optMode = new ObjectRef((Object)"");
        ObjectRef optXms = new ObjectRef((Object)"");
        ObjectRef optXmx = new ObjectRef((Object)"");
        ObjectRef optXXMaxPermSize = new ObjectRef((Object)"");
        ObjectRef optXXReservedCodeCacheSize = new ObjectRef((Object)"");
        ObjectRef otherOpts = new ObjectRef((Object)((Seq)Seq$.MODULE$.empty()));
        options2.foreach((Function1)new Serializable(optMode, optXms, optXmx, optXXMaxPermSize, optXXReservedCodeCacheSize, otherOpts){
            public static final long serialVersionUID = 0L;
            private final ObjectRef optMode$1;
            private final ObjectRef optXms$1;
            private final ObjectRef optXmx$1;
            private final ObjectRef optXXMaxPermSize$1;
            private final ObjectRef optXXReservedCodeCacheSize$1;
            private final ObjectRef otherOpts$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(String opt2) {
                block8: {
                    block7: {
                        String string2 = opt2;
                        String string3 = "-client";
                        if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block7;
                        String string4 = opt2;
                        String string5 = "-server";
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block8;
                    }
                    this.optMode$1.elem = opt2;
                    return;
                }
                if (opt2.startsWith("-Xms")) {
                    this.optXms$1.elem = opt2;
                    return;
                }
                if (opt2.startsWith("-Xmx")) {
                    this.optXmx$1.elem = opt2;
                    return;
                }
                if (opt2.startsWith("-XX:MaxPermSize")) {
                    this.optXXMaxPermSize$1.elem = opt2;
                    return;
                }
                if (opt2.startsWith("-XX:ReservedCodeCacheSize")) {
                    this.optXXReservedCodeCacheSize$1.elem = opt2;
                    return;
                }
                this.otherOpts$1.elem = (Seq)((Seq)this.otherOpts$1.elem).$colon$plus((Object)opt2, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.optMode$1 = optMode$1;
                this.optXms$1 = optXms$1;
                this.optXmx$1 = optXmx$1;
                this.optXXMaxPermSize$1 = optXXMaxPermSize$1;
                this.optXXReservedCodeCacheSize$1 = optXXReservedCodeCacheSize$1;
                this.otherOpts$1 = otherOpts$1;
            }
        });
        if (((String)optMode.elem).isEmpty()) {
            optMode.elem = "-server";
        }
        if (((String)optXms.elem).isEmpty() && ((String)optXmx.elem).isEmpty()) {
            optXms.elem = "-Xms1024m";
            optXmx.elem = "-Xmx1024m";
        }
        if (((String)optXXMaxPermSize.elem).isEmpty()) {
            optXXMaxPermSize.elem = "-XX:MaxPermSize=384m";
        }
        if (((String)optXXReservedCodeCacheSize.elem).isEmpty()) {
            optXXReservedCodeCacheSize.elem = "-XX:ReservedCodeCacheSize=192m";
        }
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)optMode.elem, (String)optXms.elem, (String)optXmx.elem, (String)optXXMaxPermSize.elem, (String)optXXReservedCodeCacheSize.elem}))).$plus$plus((GenTraversableOnce)((Seq)otherOpts.elem), Seq$.MODULE$.canBuildFrom());
    }

    public void start(InetAddress address, int port, long timeout) {
        NGServer server = new NGServer(address, port);
        AliasManager am = server.getAliasManager();
        am.addAlias(new Alias("zinc", "scala incremental compiler", Nailgun.class));
        am.addAlias(new Alias("status", "status of nailgun server", Nailgun.class));
        am.addAlias(new Alias("shutdown", "shutdown the nailgun server", Nailgun.class));
        this.shutdownTimer = Util$.MODULE$.timer(timeout, (Function0<BoxedUnit>)new Serializable(server){
            public static final long serialVersionUID = 0L;
            private final NGServer server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.shutdown(true);
            }
            {
                this.server$1 = server$1;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Nailgun.ShutdownHook(server));
        Thread thread = new Thread((Runnable)server);
        thread.setName(new StringOps(Predef$.MODULE$.augmentString("ZincNailgun(%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        thread.start();
    }

    public void nailMain(NGContext context) {
        String string2;
        this.shutdownTimer.reset();
        String string3 = string2 = context.getCommand();
        if (!("zinc" != null ? !"zinc".equals(string3) : string3 != null)) {
            this.zinc(context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = string2;
            if (!("status" != null ? !"status".equals(string4) : string4 != null)) {
                this.status(context);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string5 = string2;
                if (!("shutdown" != null ? !"shutdown".equals(string5) : string5 != null)) {
                    this.shutdown(context);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    context.err.println(new StringBuilder().append((Object)"Unknown command: ").append((Object)string2).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public void zinc(NGContext context) {
        Main$.MODULE$.run(context.getArgs(), (Option<File>)new Some((Object)new File(context.getWorkingDirectory())));
    }

    public void status(NGContext context) {
        Set<Tuple2<Setup, Compiler>> entries2 = Compiler$.MODULE$.compilerCache().entries();
        String counted = Util$.MODULE$.counted(entries2.size(), "cached compiler", "", "s");
        context.out.println(new StringBuilder().append((Object)"Nailgun server running with ").append((Object)counted).toString());
        context.out.println("");
        context.out.println(new StringBuilder().append((Object)"Version = ").append((Object)Setup$.MODULE$.versionString()).toString());
        context.out.println("");
        context.out.println(new StringBuilder().append((Object)"Zinc compiler cache limit = ").append((Object)BoxesRunTime.boxToInteger((int)Setup$Defaults$.MODULE$.compilerCacheLimit())).toString());
        context.out.println(new StringBuilder().append((Object)"Resident scalac cache limit = ").append((Object)BoxesRunTime.boxToInteger((int)Setup$Defaults$.MODULE$.residentCacheLimit())).toString());
        context.out.println(new StringBuilder().append((Object)"Analysis cache limit = ").append((Object)BoxesRunTime.boxToInteger((int)Setup$Defaults$.MODULE$.analysisCacheLimit())).toString());
        entries2.foreach((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final NGContext context$1;

            public final void apply(Tuple2<Setup, Compiler> x0$1) {
                Tuple2<Setup, Compiler> tuple2 = x0$1;
                if (tuple2 != null) {
                    Setup setup = (Setup)tuple2._1();
                    Compiler compiler = (Compiler)tuple2._2();
                    this.context$1.out.println("");
                    this.context$1.out.println(new StringOps(Predef$.MODULE$.augmentString("%s [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compiler, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(compiler.hashCode()))})));
                    PrintStream printStream = this.context$1.out;
                    Setup$.MODULE$.show(setup, (Function1<String, BoxedUnit>)new Serializable(this, printStream){
                        public static final long serialVersionUID = 0L;
                        private final PrintStream eta$0$1$1;

                        public final void apply(String x$1) {
                            this.eta$0$1$1.println(x$1);
                        }
                        {
                            this.eta$0$1$1 = eta$0$1$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.context$1 = context$1;
            }
        });
    }

    public void shutdown(NGContext context) {
        context.getNGServer().shutdown(true);
    }

    private Nailgun$() {
        MODULE$ = this;
        this.DefaultPort = 3030;
        this.DefaultTimeout = 0;
    }
}

