/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.internal.util.StackTraceElements;
import java.util.List;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ImmutableList;

final class ModuleSource {
    private final String moduleClassName;
    private final ModuleSource parent;
    private final StackTraceElements.InMemoryStackTraceElement[] partialCallStack;

    ModuleSource(Object module2, StackTraceElement[] partialCallStack) {
        this(null, module2, partialCallStack);
    }

    private ModuleSource(ModuleSource parent, Object module2, StackTraceElement[] partialCallStack) {
        Preconditions.checkNotNull(module2, "module cannot be null.");
        Preconditions.checkNotNull(partialCallStack, "partialCallStack cannot be null.");
        this.parent = parent;
        this.moduleClassName = module2.getClass().getName();
        this.partialCallStack = StackTraceElements.convertToInMemoryStackTraceElement(partialCallStack);
    }

    String getModuleClassName() {
        return this.moduleClassName;
    }

    StackTraceElement[] getPartialCallStack() {
        return StackTraceElements.convertToStackTraceElement(this.partialCallStack);
    }

    int getPartialCallStackSize() {
        return this.partialCallStack.length;
    }

    ModuleSource createChild(Object module2, StackTraceElement[] partialCallStack) {
        return new ModuleSource(this, module2, partialCallStack);
    }

    ModuleSource getParent() {
        return this.parent;
    }

    List<String> getModuleClassNames() {
        ImmutableList.Builder classNames = ImmutableList.builder();
        ModuleSource current = this;
        while (current != null) {
            String className = current.moduleClassName;
            classNames.add(className);
            current = current.parent;
        }
        return classNames.build();
    }

    int size() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.size() + 1;
    }

    int getStackTraceSize() {
        if (this.parent == null) {
            return this.partialCallStack.length;
        }
        return this.parent.getStackTraceSize() + this.partialCallStack.length;
    }

    StackTraceElement[] getStackTrace() {
        int stackTraceSize = this.getStackTraceSize();
        StackTraceElement[] callStack = new StackTraceElement[stackTraceSize];
        int cursor = 0;
        ModuleSource current = this;
        while (current != null) {
            StackTraceElement[] chunk = StackTraceElements.convertToStackTraceElement(current.partialCallStack);
            int chunkSize = chunk.length;
            System.arraycopy(chunk, 0, callStack, cursor, chunkSize);
            current = current.parent;
            cursor += chunkSize;
        }
        return callStack;
    }
}

