/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.Binder;
import com.google.inject.internal.Errors;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import org.spark_project.guava.base.Preconditions;

public final class ModuleAnnotatedMethodScannerBinding
implements Element {
    private final Object source;
    private final ModuleAnnotatedMethodScanner scanner;

    public ModuleAnnotatedMethodScannerBinding(Object source, ModuleAnnotatedMethodScanner scanner) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.scanner = Preconditions.checkNotNull(scanner, "scanner");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).scanModulesForAnnotatedMethods(this.scanner);
    }

    public String toString() {
        String string2 = String.valueOf(String.valueOf(this.scanner));
        String string3 = String.valueOf(String.valueOf(this.scanner.annotationClasses()));
        String string4 = String.valueOf(String.valueOf(Errors.convert(this.source)));
        return new StringBuilder(29 + string2.length() + string3.length() + string4.length()).append(string2).append(" which scans for ").append(string3).append(" (bound at ").append(string4).append(")").toString();
    }
}

