/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.matcher;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.spark_project.guava.base.Preconditions;

public class Matchers {
    private static final Matcher<Object> ANY = new Any();

    private Matchers() {
    }

    public static Matcher<Object> any() {
        return ANY;
    }

    public static <T> Matcher<T> not(Matcher<? super T> p) {
        return new Not(p);
    }

    private static void checkForRuntimeRetention(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        Preconditions.checkArgument(retention != null && retention.value() == RetentionPolicy.RUNTIME, "Annotation %s is missing RUNTIME retention", annotationType.getSimpleName());
    }

    public static Matcher<AnnotatedElement> annotatedWith(Class<? extends Annotation> annotationType) {
        return new AnnotatedWithType(annotationType);
    }

    public static Matcher<AnnotatedElement> annotatedWith(Annotation annotation) {
        return new AnnotatedWith(annotation);
    }

    public static Matcher<Class> subclassesOf(Class<?> superclass) {
        return new SubclassesOf(superclass);
    }

    public static Matcher<Object> only(Object value2) {
        return new Only(value2);
    }

    public static Matcher<Object> identicalTo(Object value2) {
        return new IdenticalTo(value2);
    }

    public static Matcher<Class> inPackage(Package targetPackage) {
        return new InPackage(targetPackage);
    }

    public static Matcher<Class> inSubpackage(String targetPackageName) {
        return new InSubpackage(targetPackageName);
    }

    public static Matcher<Method> returns(Matcher<? super Class<?>> returnType) {
        return new Returns(returnType);
    }

    private static class Returns
    extends AbstractMatcher<Method>
    implements Serializable {
        private final Matcher<? super Class<?>> returnType;
        private static final long serialVersionUID = 0L;

        public Returns(Matcher<? super Class<?>> returnType) {
            this.returnType = Preconditions.checkNotNull(returnType, "return type matcher");
        }

        @Override
        public boolean matches(Method m) {
            return this.returnType.matches(m.getReturnType());
        }

        public boolean equals(Object other) {
            return other instanceof Returns && ((Returns)other).returnType.equals(this.returnType);
        }

        public int hashCode() {
            return 37 * this.returnType.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.returnType));
            return new StringBuilder(9 + string2.length()).append("returns(").append(string2).append(")").toString();
        }
    }

    private static class InSubpackage
    extends AbstractMatcher<Class>
    implements Serializable {
        private final String targetPackageName;
        private static final long serialVersionUID = 0L;

        public InSubpackage(String targetPackageName) {
            this.targetPackageName = targetPackageName;
        }

        @Override
        public boolean matches(Class c) {
            String classPackageName = c.getPackage().getName();
            return classPackageName.equals(this.targetPackageName) || classPackageName.startsWith(String.valueOf(this.targetPackageName).concat("."));
        }

        public boolean equals(Object other) {
            return other instanceof InSubpackage && ((InSubpackage)other).targetPackageName.equals(this.targetPackageName);
        }

        public int hashCode() {
            return 37 * this.targetPackageName.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.targetPackageName));
            return new StringBuilder(14 + string2.length()).append("inSubpackage(").append(string2).append(")").toString();
        }
    }

    private static class InPackage
    extends AbstractMatcher<Class>
    implements Serializable {
        private final transient Package targetPackage;
        private final String packageName;
        private static final long serialVersionUID = 0L;

        public InPackage(Package targetPackage) {
            this.targetPackage = Preconditions.checkNotNull(targetPackage, "package");
            this.packageName = targetPackage.getName();
        }

        @Override
        public boolean matches(Class c) {
            return c.getPackage().equals(this.targetPackage);
        }

        public boolean equals(Object other) {
            return other instanceof InPackage && ((InPackage)other).targetPackage.equals(this.targetPackage);
        }

        public int hashCode() {
            return 37 * this.targetPackage.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.targetPackage.getName()));
            return new StringBuilder(11 + string2.length()).append("inPackage(").append(string2).append(")").toString();
        }

        public Object readResolve() {
            return Matchers.inPackage(Package.getPackage(this.packageName));
        }
    }

    private static class IdenticalTo
    extends AbstractMatcher<Object>
    implements Serializable {
        private final Object value;
        private static final long serialVersionUID = 0L;

        public IdenticalTo(Object value2) {
            this.value = Preconditions.checkNotNull(value2, "value");
        }

        @Override
        public boolean matches(Object other) {
            return this.value == other;
        }

        public boolean equals(Object other) {
            return other instanceof IdenticalTo && ((IdenticalTo)other).value == this.value;
        }

        public int hashCode() {
            return 37 * System.identityHashCode(this.value);
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(13 + string2.length()).append("identicalTo(").append(string2).append(")").toString();
        }
    }

    private static class Only
    extends AbstractMatcher<Object>
    implements Serializable {
        private final Object value;
        private static final long serialVersionUID = 0L;

        public Only(Object value2) {
            this.value = Preconditions.checkNotNull(value2, "value");
        }

        @Override
        public boolean matches(Object other) {
            return this.value.equals(other);
        }

        public boolean equals(Object other) {
            return other instanceof Only && ((Only)other).value.equals(this.value);
        }

        public int hashCode() {
            return 37 * this.value.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(6 + string2.length()).append("only(").append(string2).append(")").toString();
        }
    }

    private static class SubclassesOf
    extends AbstractMatcher<Class>
    implements Serializable {
        private final Class<?> superclass;
        private static final long serialVersionUID = 0L;

        public SubclassesOf(Class<?> superclass) {
            this.superclass = Preconditions.checkNotNull(superclass, "superclass");
        }

        @Override
        public boolean matches(Class subclass) {
            return this.superclass.isAssignableFrom(subclass);
        }

        public boolean equals(Object other) {
            return other instanceof SubclassesOf && ((SubclassesOf)other).superclass.equals(this.superclass);
        }

        public int hashCode() {
            return 37 * this.superclass.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.superclass.getSimpleName()));
            return new StringBuilder(20 + string2.length()).append("subclassesOf(").append(string2).append(".class)").toString();
        }
    }

    private static class AnnotatedWith
    extends AbstractMatcher<AnnotatedElement>
    implements Serializable {
        private final Annotation annotation;
        private static final long serialVersionUID = 0L;

        public AnnotatedWith(Annotation annotation) {
            this.annotation = Preconditions.checkNotNull(annotation, "annotation");
            Matchers.checkForRuntimeRetention(annotation.annotationType());
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            Annotation fromElement = element.getAnnotation(this.annotation.annotationType());
            return fromElement != null && this.annotation.equals(fromElement);
        }

        public boolean equals(Object other) {
            return other instanceof AnnotatedWith && ((AnnotatedWith)other).annotation.equals(this.annotation);
        }

        public int hashCode() {
            return 37 * this.annotation.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.annotation));
            return new StringBuilder(15 + string2.length()).append("annotatedWith(").append(string2).append(")").toString();
        }
    }

    private static class AnnotatedWithType
    extends AbstractMatcher<AnnotatedElement>
    implements Serializable {
        private final Class<? extends Annotation> annotationType;
        private static final long serialVersionUID = 0L;

        public AnnotatedWithType(Class<? extends Annotation> annotationType) {
            this.annotationType = Preconditions.checkNotNull(annotationType, "annotation type");
            Matchers.checkForRuntimeRetention(annotationType);
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            return element.isAnnotationPresent(this.annotationType);
        }

        public boolean equals(Object other) {
            return other instanceof AnnotatedWithType && ((AnnotatedWithType)other).annotationType.equals(this.annotationType);
        }

        public int hashCode() {
            return 37 * this.annotationType.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.annotationType.getSimpleName()));
            return new StringBuilder(21 + string2.length()).append("annotatedWith(").append(string2).append(".class)").toString();
        }
    }

    private static class Not<T>
    extends AbstractMatcher<T>
    implements Serializable {
        final Matcher<? super T> delegate;
        private static final long serialVersionUID = 0L;

        private Not(Matcher<? super T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        }

        @Override
        public boolean matches(T t) {
            return !this.delegate.matches(t);
        }

        public boolean equals(Object other) {
            return other instanceof Not && ((Not)other).delegate.equals(this.delegate);
        }

        public int hashCode() {
            return -this.delegate.hashCode();
        }

        public String toString() {
            String string2 = String.valueOf(String.valueOf(this.delegate));
            return new StringBuilder(5 + string2.length()).append("not(").append(string2).append(")").toString();
        }
    }

    private static class Any
    extends AbstractMatcher<Object>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private Any() {
        }

        @Override
        public boolean matches(Object o) {
            return true;
        }

        public String toString() {
            return "any()";
        }

        public Object readResolve() {
            return Matchers.any();
        }
    }
}

