/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Scope;
import com.google.inject.internal.AbstractProcessor;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.spi.ScopeBinding;
import java.lang.annotation.Annotation;
import org.spark_project.guava.base.Preconditions;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding command) {
        ScopeBinding existing;
        Scope scope = Preconditions.checkNotNull(command.getScope(), "scope");
        Class<? extends Annotation> annotationType = Preconditions.checkNotNull(command.getAnnotationType(), "annotation type");
        if (!Annotations.isScopeAnnotation(annotationType)) {
            this.errors.missingScopeAnnotation(annotationType);
        }
        if (!Annotations.isRetainedAtRuntime(annotationType)) {
            this.errors.missingRuntimeRetention(annotationType);
        }
        if ((existing = this.injector.state.getScopeBinding(annotationType)) != null) {
            if (!scope.equals(existing.getScope())) {
                this.errors.duplicateScopes(existing, annotationType, scope);
            }
        } else {
            this.injector.state.putScopeBinding(annotationType, command);
        }
        return true;
    }
}

