/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.logging.Logger;

public class InternalFlags {
    private static final Logger logger = Logger.getLogger(InternalFlags.class.getName());
    private static final IncludeStackTraceOption INCLUDE_STACK_TRACES = InternalFlags.parseIncludeStackTraceOption();
    private static final CustomClassLoadingOption CUSTOM_CLASS_LOADING = InternalFlags.parseCustomClassLoadingOption();
    private static final NullableProvidesOption NULLABLE_PROVIDES = InternalFlags.parseNullableProvidesOption(NullableProvidesOption.ERROR);

    public static IncludeStackTraceOption getIncludeStackTraceOption() {
        return INCLUDE_STACK_TRACES;
    }

    public static CustomClassLoadingOption getCustomClassLoadingOption() {
        return CUSTOM_CLASS_LOADING;
    }

    public static NullableProvidesOption getNullableProvidesOption() {
        return NULLABLE_PROVIDES;
    }

    private static IncludeStackTraceOption parseIncludeStackTraceOption() {
        return InternalFlags.getSystemOption("guice_include_stack_traces", IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE);
    }

    private static CustomClassLoadingOption parseCustomClassLoadingOption() {
        return InternalFlags.getSystemOption("guice_custom_class_loading", CustomClassLoadingOption.BRIDGE, CustomClassLoadingOption.OFF);
    }

    private static NullableProvidesOption parseNullableProvidesOption(NullableProvidesOption defaultValue2) {
        return InternalFlags.getSystemOption("guice_check_nullable_provides_params", defaultValue2);
    }

    private static <T extends Enum<T>> T getSystemOption(String name, T defaultValue2) {
        return InternalFlags.getSystemOption(name, defaultValue2, defaultValue2);
    }

    private static <T extends Enum<T>> T getSystemOption(final String name, T defaultValue2, T secureValue) {
        Class<T> enumType = defaultValue2.getDeclaringClass();
        String value2 = null;
        try {
            value2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
            return value2 != null && value2.length() > 0 ? Enum.valueOf(enumType, value2) : defaultValue2;
        }
        catch (SecurityException e) {
            return secureValue;
        }
        catch (IllegalArgumentException e) {
            String string2 = String.valueOf(String.valueOf(value2));
            String string3 = String.valueOf(String.valueOf(name));
            String string4 = String.valueOf(String.valueOf(Arrays.asList(enumType.getEnumConstants())));
            logger.warning(new StringBuilder(56 + string2.length() + string3.length() + string4.length()).append(string2).append(" is not a valid flag value for ").append(string3).append(". ").append(" Values must be one of ").append(string4).toString());
            return defaultValue2;
        }
    }

    public static enum NullableProvidesOption {
        IGNORE,
        WARN,
        ERROR;

    }

    public static enum CustomClassLoadingOption {
        OFF,
        BRIDGE;

    }

    public static enum IncludeStackTraceOption {
        OFF,
        ONLY_FOR_DECLARING_SOURCE,
        COMPLETE;

    }
}

