/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.internal.Errors;
import com.google.inject.spi.Message;
import java.util.Collection;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ImmutableSet;

public final class ConfigurationException
extends RuntimeException {
    private final ImmutableSet<Message> messages;
    private Object partialValue = null;
    private static final long serialVersionUID = 0L;

    public ConfigurationException(Iterable<Message> messages2) {
        this.messages = ImmutableSet.copyOf(messages2);
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public ConfigurationException withPartialValue(Object partialValue) {
        Preconditions.checkState(this.partialValue == null, "Can't clobber existing partial value %s with %s", this.partialValue, partialValue);
        ConfigurationException result2 = new ConfigurationException(this.messages);
        result2.partialValue = partialValue;
        return result2;
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    public <E> E getPartialValue() {
        return (E)this.partialValue;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice configuration errors", this.messages);
    }
}

