/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.ThreadLocalRandomProxy;
import com.codahale.metrics.UniformSnapshot;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class UniformReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private static final int BITS_PER_LONG = 63;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public UniformReservoir() {
        this(1028);
    }

    public UniformReservoir(int size2) {
        this.values = new AtomicLongArray(size2);
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.count.set(0L);
    }

    @Override
    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    @Override
    public void update(long value2) {
        long c = this.count.incrementAndGet();
        if (c <= (long)this.values.length()) {
            this.values.set((int)c - 1, value2);
        } else {
            long r = UniformReservoir.nextLong(c);
            if (r < (long)this.values.length()) {
                this.values.set((int)r, value2);
            }
        }
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandomProxy.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public Snapshot getSnapshot() {
        int s = this.size();
        ArrayList<Long> copy2 = new ArrayList<Long>(s);
        for (int i = 0; i < s; ++i) {
            copy2.add(this.values.get(i));
        }
        return new UniformSnapshot(copy2);
    }
}

