/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.spark-project.guava.base.Objects;

public class StreamHandle
extends BlockTransferMessage {
    public final long streamId;
    public final int numChunks;

    public StreamHandle(long streamId, int numChunks) {
        this.streamId = streamId;
        this.numChunks = numChunks;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.STREAM_HANDLE;
    }

    public int hashCode() {
        return Objects.hashCode(this.streamId, this.numChunks);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamId", this.streamId).add("numChunks", this.numChunks).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof StreamHandle) {
            StreamHandle o = (StreamHandle)other;
            return Objects.equal(this.streamId, o.streamId) && Objects.equal(this.numChunks, o.numChunks);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.streamId);
        buf.writeInt(this.numChunks);
    }

    public static StreamHandle decode(ByteBuf buf) {
        long streamId = buf.readLong();
        int numChunks = buf.readInt();
        return new StreamHandle(streamId, numChunks);
    }
}

