/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportChannelHandler
extends SimpleChannelInboundHandler<Message> {
    private final Logger logger = LoggerFactory.getLogger(TransportChannelHandler.class);
    private final TransportClient client;
    private final TransportResponseHandler responseHandler;
    private final TransportRequestHandler requestHandler;
    private final long requestTimeoutNs;

    public TransportChannelHandler(TransportClient client, TransportResponseHandler responseHandler, TransportRequestHandler requestHandler, long requestTimeoutMs) {
        this.client = client;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
        this.requestTimeoutNs = requestTimeoutMs * 1000L * 1000L;
    }

    public TransportClient getClient() {
        return this.client;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception in connection from " + NettyUtils.getRemoteAddress(ctx.channel()), cause);
        this.requestHandler.exceptionCaught(cause);
        this.responseHandler.exceptionCaught(cause);
        ctx.close();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            this.requestHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from request handler while unregistering channel", (Throwable)e);
        }
        try {
            this.responseHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from response handler while unregistering channel", (Throwable)e);
        }
        super.channelUnregistered(ctx);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Message request) {
        if (request instanceof RequestMessage) {
            this.requestHandler.handle((RequestMessage)request);
        } else {
            this.responseHandler.handle((ResponseMessage)request);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            boolean isActuallyOverdue;
            IdleStateEvent e = (IdleStateEvent)evt;
            boolean hasInFlightRequests = this.responseHandler.numOutstandingRequests() > 0;
            boolean bl = isActuallyOverdue = System.nanoTime() - this.responseHandler.getTimeOfLastRequestNs() > this.requestTimeoutNs;
            if (e.state() == IdleState.ALL_IDLE && hasInFlightRequests && isActuallyOverdue) {
                String address = NettyUtils.getRemoteAddress(ctx.channel());
                this.logger.error("Connection to {} has been quiet for {} ms while there are outstanding requests. Assuming connection is dead; please adjust spark.network.timeout if this is wrong.", (Object)address, (Object)(this.requestTimeoutNs / 1000L / 1000L));
                ctx.close();
            }
        }
    }
}

