/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleSecretManager
implements SecretKeyHolder {
    private final Logger logger = LoggerFactory.getLogger(ShuffleSecretManager.class);
    private final ConcurrentHashMap<String, String> shuffleSecretMap = new ConcurrentHashMap();
    private static final String SPARK_SASL_USER = "sparkSaslUser";

    public void registerApp(String appId, String shuffleSecret) {
        if (!this.shuffleSecretMap.contains(appId)) {
            this.shuffleSecretMap.put(appId, shuffleSecret);
            this.logger.info("Registered shuffle secret for application {}", (Object)appId);
        } else {
            this.logger.debug("Application {} already registered", (Object)appId);
        }
    }

    public void registerApp(String appId, ByteBuffer shuffleSecret) {
        this.registerApp(appId, JavaUtils.bytesToString(shuffleSecret));
    }

    public void unregisterApp(String appId) {
        if (this.shuffleSecretMap.contains(appId)) {
            this.shuffleSecretMap.remove(appId);
            this.logger.info("Unregistered shuffle secret for application {}", (Object)appId);
        } else {
            this.logger.warn("Attempted to unregister application {} when it is not registered", (Object)appId);
        }
    }

    @Override
    public String getSaslUser(String appId) {
        return SPARK_SASL_USER;
    }

    @Override
    public String getSecretKey(String appId) {
        return this.shuffleSecretMap.get(appId);
    }
}

