/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.spark.network.sasl.SaslEncryptionBackend;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.network.util.NettyUtils;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Preconditions;

class SaslEncryption {
    @VisibleForTesting
    static final String ENCRYPTION_HANDLER_NAME = "saslEncryption";

    SaslEncryption() {
    }

    static void addToChannel(Channel channel, SaslEncryptionBackend backend, int maxOutboundBlockSize) {
        channel.pipeline().addFirst(ENCRYPTION_HANDLER_NAME, (ChannelHandler)new EncryptionHandler(backend, maxOutboundBlockSize)).addFirst("saslDecryption", (ChannelHandler)new DecryptionHandler(backend)).addFirst("saslFrameDecoder", (ChannelHandler)NettyUtils.createFrameDecoder());
    }

    @VisibleForTesting
    static class EncryptedMessage
    extends AbstractReferenceCounted
    implements FileRegion {
        private final SaslEncryptionBackend backend;
        private final boolean isByteBuf;
        private final ByteBuf buf;
        private final FileRegion region;
        private final ByteArrayWritableChannel byteChannel;
        private ByteBuf currentHeader;
        private ByteBuffer currentChunk;
        private long currentChunkSize;
        private long currentReportedBytes;
        private long unencryptedChunkSize;
        private long transferred;

        EncryptedMessage(SaslEncryptionBackend backend, Object msg, int maxOutboundBlockSize) {
            Preconditions.checkArgument(msg instanceof ByteBuf || msg instanceof FileRegion, "Unrecognized message type: %s", msg.getClass().getName());
            this.backend = backend;
            this.isByteBuf = msg instanceof ByteBuf;
            this.buf = this.isByteBuf ? (ByteBuf)msg : null;
            this.region = this.isByteBuf ? null : (FileRegion)msg;
            this.byteChannel = new ByteArrayWritableChannel(maxOutboundBlockSize);
        }

        @Override
        public long count() {
            return this.isByteBuf ? (long)this.buf.readableBytes() : this.region.count();
        }

        @Override
        public long position() {
            return 0L;
        }

        @Override
        public long transfered() {
            return this.transferred;
        }

        @Override
        public long transferTo(WritableByteChannel target, long position) throws IOException {
            Preconditions.checkArgument(position == this.transfered(), "Invalid position.");
            long reportedWritten = 0L;
            long actuallyWritten = 0L;
            do {
                if (this.currentChunk == null) {
                    this.nextChunk();
                }
                if (this.currentHeader.readableBytes() > 0) {
                    int bytesWritten = target.write(this.currentHeader.nioBuffer());
                    this.currentHeader.skipBytes(bytesWritten);
                    actuallyWritten += (long)bytesWritten;
                    if (this.currentHeader.readableBytes() > 0) break;
                }
                actuallyWritten += (long)target.write(this.currentChunk);
                if (this.currentChunk.hasRemaining()) continue;
                long chunkBytesRemaining = this.unencryptedChunkSize - this.currentReportedBytes;
                reportedWritten += chunkBytesRemaining;
                this.transferred += chunkBytesRemaining;
                this.currentHeader.release();
                this.currentHeader = null;
                this.currentChunk = null;
                this.currentChunkSize = 0L;
                this.currentReportedBytes = 0L;
            } while (this.currentChunk == null && this.transfered() + reportedWritten < this.count());
            if (reportedWritten != 0L) {
                return reportedWritten;
            }
            if (actuallyWritten > 0L && this.currentReportedBytes < this.currentChunkSize - 1L) {
                ++this.transferred;
                ++this.currentReportedBytes;
                return 1L;
            }
            return 0L;
        }

        private void nextChunk() throws IOException {
            this.byteChannel.reset();
            if (this.isByteBuf) {
                int copied = this.byteChannel.write(this.buf.nioBuffer());
                this.buf.skipBytes(copied);
            } else {
                this.region.transferTo(this.byteChannel, this.region.transfered());
            }
            byte[] encrypted = this.backend.wrap(this.byteChannel.getData(), 0, this.byteChannel.length());
            this.currentChunk = ByteBuffer.wrap(encrypted);
            this.currentChunkSize = encrypted.length;
            this.currentHeader = Unpooled.copyLong(8L + this.currentChunkSize);
            this.unencryptedChunkSize = this.byteChannel.length();
        }

        @Override
        protected void deallocate() {
            if (this.currentHeader != null) {
                this.currentHeader.release();
            }
            if (this.buf != null) {
                this.buf.release();
            }
            if (this.region != null) {
                this.region.release();
            }
        }
    }

    private static class DecryptionHandler
    extends MessageToMessageDecoder<ByteBuf> {
        private final SaslEncryptionBackend backend;

        DecryptionHandler(SaslEncryptionBackend backend) {
            this.backend = backend;
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
            int offset;
            byte[] data;
            int length = msg.readableBytes();
            if (msg.hasArray()) {
                data = msg.array();
                offset = msg.arrayOffset();
                msg.skipBytes(length);
            } else {
                data = new byte[length];
                msg.readBytes(data);
                offset = 0;
            }
            out.add(Unpooled.wrappedBuffer(this.backend.unwrap(data, offset, length)));
        }
    }

    private static class EncryptionHandler
    extends ChannelOutboundHandlerAdapter {
        private final int maxOutboundBlockSize;
        private final SaslEncryptionBackend backend;

        EncryptionHandler(SaslEncryptionBackend backend, int maxOutboundBlockSize) {
            this.backend = backend;
            this.maxOutboundBlockSize = maxOutboundBlockSize;
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ctx.write(new EncryptedMessage(this.backend, msg, this.maxOutboundBlockSize), promise);
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            try {
                this.backend.dispose();
            }
            finally {
                super.handlerRemoved(ctx);
            }
        }
    }
}

