/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.MessageWithHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);

    @Override
    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) {
        Object body = null;
        long bodyLength = 0L;
        if (in instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess resp = (ChunkFetchSuccess)in;
            try {
                bodyLength = resp.buffer.size();
                body = resp.buffer.convertToNetty();
            }
            catch (Exception e) {
                this.logger.error(String.format("Error opening block %s for client %s", resp.streamChunkId, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, new ChunkFetchFailure(resp.streamChunkId, e.getMessage()), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 8 + msgType.encodedLength() + in.encodedLength();
        long frameLength = (long)headerLength + bodyLength;
        ByteBuf header = ctx.alloc().heapBuffer(headerLength);
        header.writeLong(frameLength);
        msgType.encode(header);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null && bodyLength > 0L) {
            out.add(new MessageWithHeader(header, body, bodyLength));
        } else {
            out.add(header);
        }
    }
}

