/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encodable;

public interface Message
extends Encodable {
    public Type type();

    public static final class Type
    extends Enum<Type>
    implements Encodable {
        public static final /* enum */ Type ChunkFetchRequest = new Type(0);
        public static final /* enum */ Type ChunkFetchSuccess = new Type(1);
        public static final /* enum */ Type ChunkFetchFailure = new Type(2);
        public static final /* enum */ Type RpcRequest = new Type(3);
        public static final /* enum */ Type RpcResponse = new Type(4);
        public static final /* enum */ Type RpcFailure = new Type(5);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        @Override
        public int encodedLength() {
            return 1;
        }

        @Override
        public void encode(ByteBuf buf) {
            buf.writeByte(this.id);
        }

        public static Type decode(ByteBuf buf) {
            byte id = buf.readByte();
            switch (id) {
                case 0: {
                    return ChunkFetchRequest;
                }
                case 1: {
                    return ChunkFetchSuccess;
                }
                case 2: {
                    return ChunkFetchFailure;
                }
                case 3: {
                    return RpcRequest;
                }
                case 4: {
                    return RpcResponse;
                }
                case 5: {
                    return RpcFailure;
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + id);
        }

        static {
            $VALUES = new Type[]{ChunkFetchRequest, ChunkFetchSuccess, ChunkFetchFailure, RpcRequest, RpcResponse, RpcFailure};
        }
    }
}

