/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.StreamChunkId;
import org.spark-project.guava.base.Objects;

public final class ChunkFetchSuccess
implements ResponseMessage {
    public final StreamChunkId streamChunkId;
    public final ManagedBuffer buffer;

    public ChunkFetchSuccess(StreamChunkId streamChunkId, ManagedBuffer buffer) {
        this.streamChunkId = streamChunkId;
        this.buffer = buffer;
    }

    @Override
    public Message.Type type() {
        return Message.Type.ChunkFetchSuccess;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkId.encodedLength();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkId.encode(buf);
    }

    public static ChunkFetchSuccess decode(ByteBuf buf) {
        StreamChunkId streamChunkId = StreamChunkId.decode(buf);
        buf.retain();
        NettyManagedBuffer managedBuf = new NettyManagedBuffer(buf.duplicate());
        return new ChunkFetchSuccess(streamChunkId, managedBuf);
    }

    public int hashCode() {
        return Objects.hashCode(this.streamChunkId, this.buffer);
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess o = (ChunkFetchSuccess)other;
            return this.streamChunkId.equals(o.streamChunkId) && this.buffer.equals(o.buffer);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamChunkId", this.streamChunkId).add("buffer", this.buffer).toString();
    }
}

