/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DefaultAbstractBag;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class SelfSpillBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 1L;
    protected MemoryLimits memLimit;

    public SelfSpillBag(int bagCount) {
        this.memLimit = new MemoryLimits(bagCount, -1.0f);
    }

    public SelfSpillBag(int bagCount, float percent) {
        this.memLimit = new MemoryLimits(bagCount, percent);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class MemoryLimits {
        private long maxMemUsage;
        private long cacheLimit = Integer.MAX_VALUE;
        private long memUsage = 0L;
        private long numObjsSizeChecked = 0L;
        private static float cachedMemUsage;
        private static long maxMem;

        public MemoryLimits(int bagCount, float percent) {
            this.init(bagCount, percent);
        }

        private void init(int bagCount, float percent) {
            if (percent < 0.0f) {
                percent = cachedMemUsage;
            }
            this.maxMemUsage = (long)((float)maxMem * percent / (float)bagCount);
            if (this.maxMemUsage < 1L) {
                this.cacheLimit = 0L;
            }
        }

        public long getCacheLimit() {
            long avgUsage;
            if (this.numObjsSizeChecked > 0L && (avgUsage = this.memUsage / this.numObjsSizeChecked) > 0L) {
                this.cacheLimit = this.maxMemUsage / avgUsage;
            }
            return this.cacheLimit;
        }

        public void addNewObjSize(long memorySize) {
            this.memUsage += memorySize;
            ++this.numObjsSizeChecked;
        }

        public long getNumObjectsSizeAdded() {
            return this.numObjsSizeChecked;
        }

        static {
            String usage;
            cachedMemUsage = 0.2f;
            maxMem = 0L;
            maxMem = Runtime.getRuntime().maxMemory();
            if (PigMapReduce.sJobConfInternal.get() != null && (usage = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.memusage")) != null) {
                cachedMemUsage = Float.parseFloat(usage);
            }
        }
    }
}

