/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.StaticDataCleanup;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.builtin.Nondeterministic;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

@Nondeterministic
public class RANDOM
extends EvalFunc<Double> {
    private Random r = null;
    private static long seedUniquifier = 8682522807148012L;

    public RANDOM() {
    }

    public RANDOM(String seed) {
        this.r = new Random(Long.parseLong(seed));
    }

    @Override
    public Double exec(Tuple input) throws IOException {
        if (this.r == null) {
            int jobidhash = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("mapred.job.id").hashCode();
            int taskIndex = Integer.valueOf(((Configuration)PigMapReduce.sJobConfInternal.get()).get("mapreduce.task.index"));
            this.r = new Random(((long)jobidhash << 32 | (long)jobidhash & 0xFFFFFFFFL) ^ (long)taskIndex << 16 ^ seedUniquifier);
            seedUniquifier *= 4292484099903637661L;
        }
        return this.r.nextDouble();
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 25));
    }

    @StaticDataCleanup
    public static void resetSeedUniquifier() {
        seedUniquifier = 8682522807148012L;
    }
}

