/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.HiveUDFBase;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.hive.HiveUtils;

public class HiveUDF
extends HiveUDFBase {
    private boolean inited = false;
    private GenericUDF evalUDF;
    SchemaInfo schemaInfo = new SchemaInfo();
    HiveUDFBase.ConstantObjectInspectInfo constantsInfo;

    public HiveUDF(String funcName) throws IOException, InstantiationException, IllegalAccessException {
        Class hiveUDFClass = HiveUDF.resolveFunc(funcName);
        if (UDF.class.isAssignableFrom(hiveUDFClass)) {
            this.evalUDF = new GenericUDFBridge(funcName, false, hiveUDFClass.getName());
        } else if (GenericUDF.class.isAssignableFrom(hiveUDFClass)) {
            this.evalUDF = (GenericUDF)hiveUDFClass.newInstance();
        } else {
            throw new IOException(HiveUDF.getErrorMessage(hiveUDFClass));
        }
    }

    public HiveUDF(String funcName, String params) throws IOException, InstantiationException, IllegalAccessException {
        this(funcName);
        this.constantsInfo = HiveUDFBase.ConstantObjectInspectInfo.parse(params);
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        if (!this.inited) {
            this.evalUDF.configure(HiveUDF.instantiateMapredContext());
            this.schemaInfo.init(this.getInputSchema(), this.evalUDF, this.constantsInfo);
            this.inited = true;
        }
        List inputs = this.schemaInfo.inputObjectInspector.getStructFieldsDataAsList((Object)input);
        GenericUDF.DeferredObject[] arguments = new GenericUDF.DeferredObject[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            arguments[i] = new GenericUDF.DeferredJavaObject(inputs.get(i));
        }
        try {
            Object returnValue = this.evalUDF.evaluate(arguments);
            return HiveUtils.convertHiveToPig(returnValue, this.schemaInfo.outputObjectInspector, null);
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<String> getShipFiles() {
        try {
            if (!this.inited) {
                this.schemaInfo.init(this.getInputSchema(), this.evalUDF, this.constantsInfo);
                this.inited = true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<String> files = super.getShipFiles();
        if (this.evalUDF.getRequiredFiles() != null) {
            files.addAll(Arrays.asList(this.evalUDF.getRequiredFiles()));
        }
        if (this.evalUDF.getRequiredJars() != null) {
            files.addAll(Arrays.asList(this.evalUDF.getRequiredJars()));
        }
        return files;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (!this.inited) {
                this.schemaInfo.init(this.getInputSchema(), this.evalUDF, this.constantsInfo);
                this.inited = true;
            }
            ResourceSchema.ResourceFieldSchema rfs = HiveUtils.getResourceFieldSchema(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.schemaInfo.outputObjectInspector));
            ResourceSchema outputSchema = new ResourceSchema();
            outputSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{rfs});
            return Schema.getPigSchema(outputSchema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finish() {
        try {
            this.evalUDF.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class SchemaInfo {
        private StructObjectInspector inputObjectInspector;
        private ObjectInspector outputObjectInspector;

        SchemaInfo() {
        }

        private void init(Schema inputSchema, GenericUDF evalUDF, HiveUDFBase.ConstantObjectInspectInfo constantsInfo) throws IOException {
            ResourceSchema rs = new ResourceSchema(inputSchema);
            ResourceSchema.ResourceFieldSchema wrappedTupleFieldSchema = new ResourceSchema.ResourceFieldSchema();
            wrappedTupleFieldSchema.setType((byte)110);
            wrappedTupleFieldSchema.setSchema(rs);
            TypeInfo ti = HiveUtils.getTypeInfo(wrappedTupleFieldSchema);
            this.inputObjectInspector = (StructObjectInspector)HiveUtils.createObjectInspector(ti);
            try {
                ObjectInspector[] arguments = new ObjectInspector[inputSchema.size()];
                for (int i = 0; i < inputSchema.size(); ++i) {
                    arguments[i] = constantsInfo != null && !constantsInfo.isEmpty() && constantsInfo.get(i) != null ? constantsInfo.get(i) : ((StructField)this.inputObjectInspector.getAllStructFieldRefs().get(i)).getFieldObjectInspector();
                }
                this.outputObjectInspector = evalUDF.initialize(arguments);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

