/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class AlgebraicDoubleMathBase
extends AlgebraicMathBase<Double>
implements Accumulator<Double> {
    private Double intermediateVal = null;

    protected static Double getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return 0.0;
            }
            case MIN: {
                return Double.POSITIVE_INFINITY;
            }
            case MAX: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return null;
    }

    private static Double doWork(Double arg1, Double arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        switch (op) {
            case MAX: {
                return Math.max(arg1, arg2);
            }
            case MIN: {
                return Math.min(arg1, arg2);
            }
            case SUM: {
                return arg1 + arg2;
            }
        }
        return null;
    }

    protected static Double doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values == null || values.size() == 0L) {
            return null;
        }
        double sofar = AlgebraicDoubleMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Number n = (Number)t.get(0);
                if (n == null) continue;
                Double d = n.doubleValue();
                sawNonNull = true;
                sofar = AlgebraicDoubleMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on Doubles", errCode, 4, exp);
            }
        }
        return sawNonNull ? Double.valueOf(sofar) : null;
    }

    @Override
    public Double exec(Tuple input) throws IOException {
        try {
            return AlgebraicDoubleMathBase.doTupleWork(input, this.opProvider);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Double curVal = AlgebraicDoubleMathBase.doTupleWork(b, this.opProvider);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicDoubleMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicDoubleMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on Doubles", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public Double getValue() {
        return this.intermediateVal;
    }

    public static abstract class Final
    extends AlgebraicMathBase.Final<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                return AlgebraicDoubleMathBase.doTupleWork(input, this);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Doubles", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicDoubleMathBase.doTupleWork(input, this));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on Doubles", errCode, 4, e);
            }
        }
    }
}

