/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

public class MapRedUtil {
    private static Log log = LogFactory.getLog(MapRedUtil.class);
    private static final TupleFactory tf = TupleFactory.getInstance();
    public static final String FILE_SYSTEM_NAME = "fs.default.name";
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    private static Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            long cmp = o1.length - o2.length;
            return cmp == 0L ? 0 : (cmp < 0L ? -1 : 1);
        }
    };

    public static <E> Map<E, Pair<Integer, Integer>> loadPartitionFileFromLocalCache(String keyDistFile, Integer[] totalReducers, byte keyType, Configuration mapConf) throws IOException {
        HashMap<Object, Pair<Integer, Integer>> reducerMap = new HashMap<Object, Pair<Integer, Integer>>();
        Configuration conf = new Configuration(false);
        if (mapConf.get("yarn.resourcemanager.principal") != null) {
            conf.set("yarn.resourcemanager.principal", mapConf.get("yarn.resourcemanager.principal"));
        }
        if (((Configuration)PigMapReduce.sJobConfInternal.get()).get("fs.file.impl") != null) {
            conf.set("fs.file.impl", ((Configuration)PigMapReduce.sJobConfInternal.get()).get("fs.file.impl"));
        }
        if (((Configuration)PigMapReduce.sJobConfInternal.get()).get("fs.hdfs.impl") != null) {
            conf.set("fs.hdfs.impl", ((Configuration)PigMapReduce.sJobConfInternal.get()).get("fs.hdfs.impl"));
        }
        MapRedUtil.copyTmpFileConfigurationValues((Configuration)PigMapReduce.sJobConfInternal.get(), conf);
        conf.set(FILE_SYSTEM_NAME, "file:///");
        ReadToEndLoader loader = new ReadToEndLoader((LoadFunc)Utils.getTmpFileStorageObject((Configuration)PigMapReduce.sJobConfInternal.get()), conf, keyDistFile, 0);
        Tuple t = loader.getNext();
        if (t == null) {
            log.warn((Object)("Empty dist file: " + keyDistFile));
            return reducerMap;
        }
        Map distMap = (Map)t.get(0);
        DataBag partitionList = (DataBag)distMap.get("partition.list");
        totalReducers[0] = Integer.valueOf("" + distMap.get("totalreducers"));
        for (Tuple idxTuple : partitionList) {
            Object keyT;
            Integer maxIndex = (Integer)idxTuple.get(idxTuple.size() - 1);
            Integer minIndex = (Integer)idxTuple.get(idxTuple.size() - 2);
            if (maxIndex < minIndex) {
                maxIndex = totalReducers[0] + maxIndex;
            }
            if (idxTuple.size() > 3) {
                Tuple keyTuple = tf.newTuple();
                for (int i = 0; i < idxTuple.size() - 2; ++i) {
                    keyTuple.append(idxTuple.get(i));
                }
                keyT = keyTuple;
            } else if (keyType == 110) {
                keyT = tf.newTuple(1);
                ((Tuple)keyT).set(0, idxTuple.get(0));
            } else {
                keyT = idxTuple.get(0);
            }
            Integer cnt = maxIndex - minIndex;
            reducerMap.put(keyT, new Pair<Integer, Integer>(minIndex, cnt));
        }
        return reducerMap;
    }

    public static void copyTmpFileConfigurationValues(Configuration fromConf, Configuration toConf) {
        if (fromConf.getBoolean("pig.tmpfilecompression", false)) {
            toConf.setBoolean("pig.tmpfilecompression", true);
            if (fromConf.get("pig.tmpfilecompression.codec") != null) {
                toConf.set("pig.tmpfilecompression.codec", fromConf.get("pig.tmpfilecompression.codec"));
            }
            if (fromConf.get("pig.tmpfilecompression.storage") != null) {
                toConf.set("pig.tmpfilecompression.storage", fromConf.get("pig.tmpfilecompression.storage"));
            }
        }
    }

    public static void setupUDFContext(Configuration job) throws IOException {
        UDFContext udfc = UDFContext.getUDFContext();
        udfc.addJobConf(job);
        if (udfc.isUDFConfEmpty()) {
            udfc.deserialize();
        }
    }

    public static void setupStreamingDirsConfSingle(POStore st, PigContext pigContext, Configuration conf) throws IOException {
        String outputPathString = st.getSFile().getFileName();
        if (HadoopShims.hasFileSystemImpl(new Path(outputPathString), conf)) {
            conf.set("pig.streaming.log.dir", new Path(outputPathString, "_logs").toString());
        } else {
            String tmpLocationStr = FileLocalizer.getTemporaryPath(pigContext).toString();
            Path tmpLocation = new Path(tmpLocationStr);
            conf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
        }
        conf.set("pig.streaming.task.output.dir", outputPathString);
    }

    public static void setupStreamingDirsConfMulti(PigContext pigContext, Configuration conf) throws IOException {
        String tmpLocationStr = FileLocalizer.getTemporaryPath(pigContext).toString();
        Path tmpLocation = new Path(tmpLocationStr);
        conf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
        conf.set("pig.streaming.task.output.dir", tmpLocation.toString());
    }

    public static FileSpec checkLeafIsStore(PhysicalPlan plan, PigContext pigContext) throws ExecException {
        try {
            PhysicalOperator leaf = (PhysicalOperator)plan.getLeaves().get(0);
            FileSpec spec = null;
            if (!(leaf instanceof POStore)) {
                String scope = leaf.getOperatorKey().getScope();
                POStore str = new POStore(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
                spec = new FileSpec(FileLocalizer.getTemporaryPath(pigContext).toString(), new FuncSpec(Utils.getTmpFileCompressorName(pigContext)));
                str.setSFile(spec);
                plan.addAsLeaf(str);
            } else {
                spec = ((POStore)leaf).getSFile();
            }
            return spec;
        }
        catch (Exception e) {
            int errCode = 2045;
            String msg = "Internal error. Not able to check if the leaf node is a store operator.";
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    public static List<FileStatus> getAllFileRecursively(List<FileStatus> files, Configuration conf) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        int len = files.size();
        for (int i = 0; i < len; ++i) {
            FileStatus file = files.get(i);
            if (file.isDir()) {
                Path p = file.getPath();
                FileSystem fs = p.getFileSystem(conf);
                MapRedUtil.addInputPathRecursively(result, fs, p, hiddenFileFilter);
                continue;
            }
            result.add(file);
        }
        log.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    private static void addInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDir()) {
                MapRedUtil.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    public static long getPathLength(FileSystem fs, FileStatus status) throws IOException {
        return MapRedUtil.getPathLength(fs, status, Long.MAX_VALUE);
    }

    public static long getPathLength(FileSystem fs, FileStatus status, long max) throws IOException {
        if (!status.isDir()) {
            return status.getLen();
        }
        FileStatus[] children = fs.listStatus(status.getPath(), hiddenFileFilter);
        long size = 0L;
        for (FileStatus child : children) {
            if ((size += MapRedUtil.getPathLength(fs, child, max)) <= max) continue;
            return size;
        }
        return size;
    }

    public static List<List<InputSplit>> getCombinePigSplits(List<InputSplit> oneInputSplits, long maxCombinedSplitSize, Configuration conf) throws IOException, InterruptedException {
        ArrayList<InputSplit> combinedSplits;
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<Object, Node> nodeMap = new HashMap<Object, Node>();
        ArrayList<List<InputSplit>> result = new ArrayList<List<InputSplit>>();
        ArrayList<Long> resultLengths = new ArrayList<Long>();
        long comparableSplitId = 0L;
        int size = 0;
        int nSplits = oneInputSplits.size();
        InputSplit lastSplit = null;
        int emptyCnt = 0;
        for (InputSplit split : oneInputSplits) {
            if (split.getLength() == 0L) {
                ++emptyCnt;
                continue;
            }
            if (split.getLength() >= maxCombinedSplitSize) {
                ++comparableSplitId;
                ArrayList<InputSplit> combinedSplits2 = new ArrayList<InputSplit>();
                combinedSplits2.add(split);
                result.add(combinedSplits2);
                resultLengths.add(split.getLength());
                continue;
            }
            String[] locations = split.getLocations();
            if (locations.length == 0) {
                ++comparableSplitId;
                ArrayList<InputSplit> combinedSplits3 = new ArrayList<InputSplit>();
                combinedSplits3.add(split);
                result.add(combinedSplits3);
                resultLengths.add(split.getLength());
                continue;
            }
            ComparableSplit csplit = new ComparableSplit(split, comparableSplitId++);
            Arrays.sort(locations);
            HashSet<Object> locationSeen = new HashSet<Object>();
            for (Object object : locations) {
                if (locationSeen.contains(object)) continue;
                Node node = (Node)nodeMap.get(object);
                if (node == null) {
                    node = new Node();
                    nodes.add(node);
                    nodeMap.put(object, node);
                }
                node.add(csplit);
                csplit.add(node);
                locationSeen.add(object);
            }
            lastSplit = split;
            ++size;
        }
        if (nSplits > 0 && emptyCnt == nSplits) {
            combinedSplits = new ArrayList<InputSplit>();
            combinedSplits.add(oneInputSplits.get(0));
            result.add(combinedSplits);
        } else if (size == 1) {
            combinedSplits = new ArrayList();
            combinedSplits.add(lastSplit);
            result.add(combinedSplits);
        } else if (size > 1) {
            Collections.sort(nodes, nodeComparator);
            DummySplit dummy = new DummySplit();
            ComparableSplit dummyComparableSplit = new ComparableSplit(dummy, -1L);
            block2: for (Node node : nodes) {
                node.sort();
                long totalSize = 0L;
                ArrayList<ComparableSplit> splits = node.getSplits();
                ArrayList<InputSplit> combinedSplits4 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                while (!splits.isEmpty()) {
                    combinedSplits4.add(splits.get(0).getSplit());
                    combinedComparableSplits.add(splits.get(0));
                    int startIdx = 1;
                    int n = splits.size();
                    long spaceLeft = maxCombinedSplitSize - (totalSize += splits.get(0).getSplit().getLength());
                    dummy.setLength(spaceLeft);
                    int idx = Collections.binarySearch(node.getSplits().subList(startIdx, n), dummyComparableSplit);
                    idx = -idx - 1 + startIdx;
                    while (idx < n) {
                        long thisLen = splits.get(idx).getSplit().getLength();
                        combinedSplits4.add(splits.get(idx).getSplit());
                        combinedComparableSplits.add(splits.get(idx));
                        totalSize += thisLen;
                        if ((spaceLeft -= thisLen) <= 0L || (startIdx = idx + 1) >= n) break;
                        dummy.setLength(spaceLeft);
                        idx = Collections.binarySearch(node.getSplits().subList(startIdx, n), dummyComparableSplit);
                        idx = -idx - 1 + startIdx;
                    }
                    if (totalSize > maxCombinedSplitSize / 2L) {
                        result.add(combinedSplits4);
                        resultLengths.add(totalSize);
                        MapRedUtil.removeSplits(combinedComparableSplits);
                        totalSize = 0L;
                        combinedSplits4 = new ArrayList();
                        combinedComparableSplits.clear();
                        splits = node.getSplits();
                        continue;
                    }
                    if (combinedSplits4.size() != n) {
                        throw new AssertionError((Object)"Combined split logic error!");
                    }
                    continue block2;
                }
            }
            ArrayList<ComparableSplit> leftoverSplits = new ArrayList<ComparableSplit>();
            HashSet<InputSplit> seen = new HashSet<InputSplit>();
            for (Node node : nodes) {
                for (ComparableSplit split : node.getSplits()) {
                    if (seen.contains(split.getSplit())) continue;
                    seen.add(split.getSplit());
                    leftoverSplits.add(split);
                }
            }
            if (!leftoverSplits.isEmpty()) {
                long totalSize = 0L;
                ArrayList<InputSplit> combinedSplits5 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                int n = leftoverSplits.size();
                for (int i = 0; i < n; ++i) {
                    ComparableSplit split = (ComparableSplit)leftoverSplits.get(i);
                    long thisLen = split.getSplit().getLength();
                    if (totalSize + thisLen >= maxCombinedSplitSize) {
                        MapRedUtil.removeSplits(combinedComparableSplits);
                        result.add(combinedSplits5);
                        resultLengths.add(totalSize);
                        combinedSplits5 = new ArrayList();
                        combinedComparableSplits.clear();
                        totalSize = 0L;
                    }
                    combinedSplits5.add(split.getSplit());
                    combinedComparableSplits.add(split);
                    totalSize += split.getSplit().getLength();
                    if (i != n - 1) continue;
                    for (int j = 0; j < result.size(); ++j) {
                        if ((Long)resultLengths.get(j) + totalSize > maxCombinedSplitSize) continue;
                        List isList = (List)result.get(j);
                        for (InputSplit csplit : combinedSplits5) {
                            isList.add(csplit);
                        }
                        MapRedUtil.removeSplits(combinedComparableSplits);
                        combinedSplits5.clear();
                        break;
                    }
                    if (combinedSplits5.isEmpty()) continue;
                    MapRedUtil.removeSplits(combinedComparableSplits);
                    result.add(combinedSplits5);
                }
            }
        }
        log.info((Object)("Total input paths (combined) to process : " + result.size()));
        return result;
    }

    private static void removeSplits(List<ComparableSplit> splits) {
        for (ComparableSplit split : splits) {
            split.removeFromNodes();
        }
    }

    public String inputSplitToString(InputSplit[] splits) throws IOException, InterruptedException {
        StringBuilder st = new StringBuilder();
        st.append("Number of splits :" + splits.length + "\n");
        long len = 0L;
        for (InputSplit split : splits) {
            len += split.getLength();
        }
        st.append("Total Length = " + len + "\n");
        for (int i = 0; i < splits.length; ++i) {
            st.append("Input split[" + i + "]:\n   Length = " + splits[i].getLength() + "\n  Locations:\n");
            for (String location : splits[i].getLocations()) {
                st.append("    " + location + "\n");
            }
            st.append("\n-----------------------\n");
        }
        return st.toString();
    }

    private static class Node {
        private long length = 0L;
        private ArrayList<ComparableSplit> splits = new ArrayList();
        private boolean sorted = false;

        Node() throws IOException, InterruptedException {
        }

        void add(ComparableSplit split) throws IOException, InterruptedException {
            this.splits.add(split);
            ++this.length;
        }

        void remove(ComparableSplit split) {
            int index;
            if (!this.sorted) {
                this.sort();
            }
            if ((index = Collections.binarySearch(this.splits, split)) >= 0) {
                this.splits.remove(index);
                --this.length;
            }
        }

        void sort() {
            if (!this.sorted) {
                Collections.sort(this.splits);
                this.sorted = true;
            }
        }

        ArrayList<ComparableSplit> getSplits() {
            return this.splits;
        }

        public long getLength() {
            return this.length;
        }
    }

    private static class DummySplit
    extends InputSplit {
        private long length;

        private DummySplit() {
        }

        public String[] getLocations() {
            return null;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }
    }

    private static final class ComparableSplit
    implements Comparable<ComparableSplit> {
        private InputSplit rawInputSplit;
        private HashSet<Node> nodes;
        private long id;

        ComparableSplit(InputSplit split, long id) {
            this.rawInputSplit = split;
            this.nodes = new HashSet();
            this.id = id;
        }

        void add(Node node) {
            this.nodes.add(node);
        }

        void removeFromNodes() {
            for (Node node : this.nodes) {
                node.remove(this);
            }
        }

        public InputSplit getSplit() {
            return this.rawInputSplit;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ComparableSplit)) {
                return false;
            }
            return this.compareTo((ComparableSplit)other) == 0;
        }

        public int hashCode() {
            return 41;
        }

        @Override
        public int compareTo(ComparableSplit other) {
            try {
                long cmp = this.rawInputSplit.getLength() - other.rawInputSplit.getLength();
                return cmp == 0L ? (this.id == other.id ? 0 : (this.id < other.id ? -1 : 1)) : (cmp < 0L ? 1 : -1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

