/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.AccumulativeTupleBuffer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.MultiQueryPackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.backend.hadoop.executionengine.util.AccumulatorOptimizerUtil;
import org.apache.pig.data.AccumulativeBag;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.ReadOnceBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.Illustrator;

public class POPackage
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    transient Iterator<NullableTuple> tupIter;
    protected Object key;
    protected int numInputs;
    private boolean lastBagReadOnly = true;
    protected Packager pkgr;
    protected PigNullableWritable keyWritable;
    private transient boolean initialized;
    private transient boolean useDefaultBag;
    private transient int accumulativeBatchSize;

    public POPackage(OperatorKey k) {
        this(k, -1, null);
    }

    public POPackage(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POPackage(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POPackage(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        this(k, rp, inp, new Packager());
    }

    public POPackage(OperatorKey k, int rp, List<PhysicalOperator> inp, Packager pkgr) {
        super(k, rp, inp);
        this.numInputs = -1;
        this.pkgr = pkgr;
    }

    public POPackage(POPackage copy) {
        super(copy);
        this.numInputs = copy.numInputs;
        this.pkgr = copy.pkgr;
        this.pkgr.keyInfo = copy.pkgr.keyInfo;
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        super.setIllustrator(illustrator);
        this.pkgr.setIllustrator(illustrator);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Package(" + this.pkgr.name() + ")[" + DataType.findTypeName(this.resultType) + "]{" + DataType.findTypeName(this.pkgr.getKeyType()) + "} - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPackage(this);
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void attachInput(PigNullableWritable k, Iterator<NullableTuple> inp) {
        try {
            this.tupIter = inp;
            this.key = this.pkgr.getKey(k);
            this.keyWritable = k;
            this.inputAttached = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error attaching input for key " + k + " in " + this.name() + " at location " + this.getOriginalLocations(), e);
        }
    }

    @Override
    public void detachInput() {
        this.tupIter = null;
        this.key = null;
        this.inputAttached = false;
    }

    public int getNumInps() {
        return this.numInputs;
    }

    public void setNumInps(int numInps) {
        this.numInputs = numInps;
        this.pkgr.setNumInputs(numInps);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.initialized) {
            String bagType;
            this.initialized = true;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                this.useDefaultBag = true;
            }
            this.accumulativeBatchSize = AccumulatorOptimizerUtil.getAccumulativeBatchSize();
            if (this.pkgr instanceof MultiQueryPackager) {
                this.lastBagReadOnly = false;
            }
        }
        int numInputs = this.pkgr.getNumInputs(this.keyWritable.getIndex());
        boolean[] readOnce = new boolean[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            readOnce[i] = false;
        }
        if (this.isInputAttached()) {
            DataBag[] dbs = null;
            dbs = new DataBag[numInputs];
            if (this.isAccumulative()) {
                readOnce[numInputs - 1] = false;
                POPackageTupleBuffer buffer = new POPackageTupleBuffer(this.accumulativeBatchSize, this.key, this.tupIter);
                for (int i = 0; i < numInputs; ++i) {
                    dbs[i] = new AccumulativeBag(buffer, i);
                }
            } else {
                if (this.lastBagReadOnly) {
                    readOnce[numInputs - 1] = true;
                }
                for (int i = 0; i < numInputs; ++i) {
                    dbs[i] = this.useDefaultBag ? mBagFactory.newDefaultBag() : new InternalCachedBag(numInputs);
                }
                while (this.tupIter.hasNext()) {
                    NullableTuple ntup = this.tupIter.next();
                    byte index = ntup.getIndex();
                    if (index == numInputs - 1) {
                        if (!this.pkgr.getUseSecondaryKey()) {
                            dbs[index] = new PeekedBag(this.pkgr, ntup, this.tupIter, this.keyWritable);
                            break;
                        }
                        if (dbs[index] == null) {
                            dbs[index] = this.useDefaultBag ? mBagFactory.newDefaultBag() : new InternalCachedBag(numInputs);
                        }
                    }
                    Tuple copy = this.pkgr.getValueTuple(this.keyWritable, ntup, index);
                    if (numInputs == 1) {
                        dbs[0].add(copy);
                    } else {
                        dbs[index].add(copy);
                    }
                    if (POPackage.getReporter() == null) continue;
                    POPackage.getReporter().progress();
                }
            }
            this.pkgr.attachInput(this.key, dbs, readOnce);
            this.detachInput();
        }
        return this.pkgr.getNext();
    }

    public Packager getPkgr() {
        return this.pkgr;
    }

    public void setPkgr(Packager pkgr) {
        this.pkgr = pkgr;
        pkgr.setParent(this);
        pkgr.setIllustrator(this.illustrator);
    }

    @Override
    public POPackage clone() throws CloneNotSupportedException {
        POPackage clone = (POPackage)super.clone();
        clone.mKey = new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope));
        clone.requestedParallelism = this.requestedParallelism;
        clone.resultType = this.resultType;
        clone.numInputs = this.numInputs;
        clone.pkgr = this.pkgr.clone();
        return clone;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return this.pkgr.illustratorMarkup(in, out, eqClassIndex);
    }

    public int numberOfEquivalenceClasses() {
        return this.pkgr.numberOfEquivalenceClasses();
    }

    private static class PeekedBag
    extends ReadOnceBag {
        private static final long serialVersionUID = 1L;
        NullableTuple head;
        int index;

        public PeekedBag(Packager pkgr, NullableTuple head, Iterator<NullableTuple> tupIter, PigNullableWritable keyWritable) {
            super(pkgr, tupIter, keyWritable);
            this.head = head;
            this.index = head.getIndex();
        }

        @Override
        public Iterator<Tuple> iterator() {
            return new Iterator<Tuple>(){
                boolean headReturned = false;

                @Override
                public boolean hasNext() {
                    if (!this.headReturned) {
                        return true;
                    }
                    return PeekedBag.this.tupIter.hasNext();
                }

                @Override
                public Tuple next() {
                    if (!this.headReturned) {
                        this.headReturned = true;
                        try {
                            return PeekedBag.this.pkgr.getValueTuple(PeekedBag.this.keyWritable, PeekedBag.this.head, PeekedBag.this.head.getIndex());
                        }
                        catch (ExecException e) {
                            throw new RuntimeException("PeekedBag failed to get value tuple : " + e.toString());
                        }
                    }
                    NullableTuple ntup = (NullableTuple)PeekedBag.this.tupIter.next();
                    Tuple ret = null;
                    try {
                        ret = PeekedBag.this.pkgr.getValueTuple(PeekedBag.this.keyWritable, ntup, PeekedBag.this.index);
                    }
                    catch (ExecException e) {
                        throw new RuntimeException("PeekedBag failed to get value tuple : " + e.toString());
                    }
                    if (PhysicalOperator.getReporter() != null) {
                        PhysicalOperator.getReporter().progress();
                    }
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("PeekedBag does not support removal");
                }
            };
        }
    }

    public class POPackageTupleBuffer
    implements AccumulativeTupleBuffer {
        private List<Tuple>[] bags;
        private Iterator<NullableTuple> iter;
        private int batchSize;
        private Object currKey;

        public POPackageTupleBuffer(int batchSize, Object key, Iterator<NullableTuple> iter) {
            this.batchSize = batchSize;
            this.currKey = key;
            this.iter = iter;
            this.bags = new List[POPackage.this.numInputs];
            for (int i = 0; i < POPackage.this.numInputs; ++i) {
                this.bags[i] = new ArrayList<Tuple>(batchSize);
            }
        }

        @Override
        public boolean hasNextBatch() {
            return this.iter.hasNext();
        }

        @Override
        public void nextBatch() throws IOException {
            int i;
            for (i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            POPackage.this.key = this.currKey;
            for (i = 0; i < this.batchSize && this.iter.hasNext(); ++i) {
                NullableTuple ntup = this.iter.next();
                byte index = ntup.getIndex();
                Tuple copy = POPackage.this.pkgr.getValueTuple(POPackage.this.keyWritable, ntup, index);
                if (POPackage.this.numInputs == 1) {
                    this.bags[0].add(copy);
                    continue;
                }
                this.bags[index].add(copy);
            }
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            this.iter = null;
        }

        @Override
        public Iterator<Tuple> getTuples(int index) {
            return this.bags[index].iterator();
        }

        public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
            return POPackage.this.illustratorMarkup(in, out, eqClassIndex);
        }
    }
}

