/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.optimizer.SecondaryKeyOptimizer;
import org.apache.pig.backend.hadoop.executionengine.util.SecondaryKeyOptimizerUtil;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

@InterfaceAudience.Private
public class SecondaryKeyOptimizerMR
extends MROpPlanVisitor
implements SecondaryKeyOptimizer {
    private static Log log = LogFactory.getLog(SecondaryKeyOptimizerMR.class);
    private SecondaryKeyOptimizerUtil.SecondaryKeyOptimizerInfo info;

    public SecondaryKeyOptimizerMR(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        if (mr.isGlobalSort()) {
            return;
        }
        if (mr.getCustomPartitioner() != null) {
            return;
        }
        this.info = SecondaryKeyOptimizerUtil.applySecondaryKeySort(mr.mapPlan, mr.reducePlan);
        if (this.info != null && this.info.isUseSecondaryKey()) {
            mr.setUseSecondaryKey(true);
            mr.setSecondarySortOrder(this.info.getSecondarySortOrder());
            log.info((Object)("Using Secondary Key Optimization for MapReduce node " + mr.getOperatorKey()));
        }
    }

    @Override
    public int getNumSortRemoved() {
        return this.info == null ? 0 : this.info.getNumSortRemoved();
    }

    @Override
    public int getNumDistinctChanged() {
        return this.info == null ? 0 : this.info.getNumDistinctChanged();
    }

    @Override
    public int getNumUseSecondaryKey() {
        return this.info == null ? 0 : this.info.getNumUseSecondaryKey();
    }
}

