/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class PigRecordReader
extends RecordReader<Text, Tuple> {
    private static final Log LOG = LogFactory.getLog(PigRecordReader.class);
    private transient String counterGroup = "";
    private long timingFrequency = 100L;
    private boolean doTiming = false;
    Tuple curValue = null;
    private RecordReader<?, ?> curReader;
    private LoadFunc loadfunc;
    private transient String counterName = null;
    private InputFormat<?, ?> inputformat;
    private PigSplit pigSplit;
    private int idx;
    private long progress;
    private TaskAttemptContext context;
    private PigStatusReporter reporter;
    private final long limit;
    private long recordCount = 0L;
    private Configuration inputSpecificConf;

    public PigRecordReader(InputFormat<?, ?> inputformat, PigSplit pigSplit, LoadFunc loadFunc, TaskAttemptContext context, long limit) throws IOException, InterruptedException {
        this.inputformat = inputformat;
        this.pigSplit = pigSplit;
        this.loadfunc = loadFunc;
        this.context = context;
        this.reporter = PigStatusReporter.getInstance();
        this.inputSpecificConf = context.getConfiguration();
        this.curReader = null;
        this.progress = 0L;
        this.idx = 0;
        this.limit = limit;
        this.initNextRecordReader();
        this.doTiming = this.inputSpecificConf.getBoolean("pig.udf.profile", false);
        if (this.doTiming) {
            this.counterGroup = loadFunc.toString();
            this.timingFrequency = this.inputSpecificConf.getLong("pig.udf.profile.frequency", 100L);
        }
    }

    public void close() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Tuple getCurrentValue() throws IOException, InterruptedException {
        if (this.counterName != null && this.curValue != null) {
            this.reporter.incrCounter("MultiInputCounters", this.counterName, 1L);
        }
        return this.curValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        long subprogress = 0L;
        if (null != this.curReader) {
            subprogress = (long)(this.curReader.getProgress() * (float)this.pigSplit.getLength(this.idx - 1));
        }
        return Math.min(1.0f, (float)(this.progress + subprogress) / (float)this.pigSplit.getLength());
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.pigSplit = (PigSplit)split;
        this.context = context;
        ConfigurationUtil.mergeConf(context.getConfiguration(), this.inputSpecificConf);
        PigInputFormat.passLoadSignature(this.loadfunc, this.pigSplit.getInputIndex(), context.getConfiguration());
        if (null != this.curReader) {
            this.curReader.initialize(this.pigSplit.getWrappedSplit(), context);
            this.loadfunc.prepareToRead(this.curReader, this.pigSplit);
        }
        if (this.pigSplit.isMultiInputs() && !this.pigSplit.disableCounter()) {
            this.counterName = PigRecordReader.getMultiInputsCounerName(this.pigSplit, this.inputSpecificConf);
            if (this.counterName != null) {
                this.reporter.incrCounter("MultiInputCounters", this.counterName, 0L);
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.limit != -1L && this.recordCount >= this.limit) {
            return false;
        }
        boolean timeThis = this.doTiming && (this.recordCount + 1L) % this.timingFrequency == 0L;
        long startNanos = 0L;
        if (timeThis) {
            startNanos = System.nanoTime();
        }
        while (this.curReader == null || (this.curValue = this.loadfunc.getNext()) == null) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        if (timeThis) {
            this.reporter.incrCounter(this.counterGroup, "approx_microsecs", (long)Math.round((System.nanoTime() - startNanos) / 1000L) * this.timingFrequency);
        }
        ++this.recordCount;
        return true;
    }

    private static String getMultiInputsCounerName(PigSplit pigSplit, Configuration conf) throws IOException {
        ArrayList inputs = (ArrayList)ObjectSerializer.deserialize(conf.get("pig.inputs"));
        String fname = ((FileSpec)inputs.get(pigSplit.getInputIndex())).getFileName();
        return PigStatsUtil.getMultiInputsCounterName(fname, pigSplit.getInputIndex());
    }

    protected boolean initNextRecordReader() throws IOException, InterruptedException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
            if (this.idx > 0) {
                this.progress += this.pigSplit.getLength(this.idx - 1);
            }
            this.context.progress();
        }
        if (this.idx == this.pigSplit.getNumPaths()) {
            return false;
        }
        try {
            this.pigSplit.setCurrentIdx(this.idx);
            this.curReader = this.inputformat.createRecordReader(this.pigSplit.getWrappedSplit(), this.context);
            LOG.info((Object)("Current split being processed " + this.pigSplit.getWrappedSplit()));
            if (this.idx > 0) {
                this.curReader.initialize(this.pigSplit.getWrappedSplit(), this.context);
                this.loadfunc.prepareToRead(this.curReader, this.pigSplit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.idx;
        return true;
    }
}

