/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.JVMReuseImpl;
import org.apache.pig.StaticDataCleanup;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JVMReuseManager {
    private static Log LOG = LogFactory.getLog(JVMReuseImpl.class);
    private List<Method> cleanupMethods = new ArrayList<Method>();
    private static JVMReuseManager instance = new JVMReuseManager();

    private JVMReuseManager() {
    }

    public static JVMReuseManager getInstance() {
        return instance;
    }

    public void registerForStaticDataCleanup(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(StaticDataCleanup.class)) continue;
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) {
                throw new RuntimeException("Method " + method.getName() + " in class " + clazz.getName() + "should be public and static as it is annotated with  ");
            }
            LOG.debug((Object)("Method " + method.getName() + " in class " + method.getDeclaringClass() + " registered for static data cleanup"));
            JVMReuseManager.instance.cleanupMethods.add(method);
        }
    }

    List<Method> getStaticDataCleanupMethods() {
        return this.cleanupMethods;
    }
}

