/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import sqlline.BufferedRows;
import sqlline.ClassNameCompleter;
import sqlline.ColorBuffer;
import sqlline.CommandHandler;
import sqlline.Commands;
import sqlline.DatabaseConnection;
import sqlline.DatabaseConnections;
import sqlline.DispatchCallback;
import sqlline.IncrementalRows;
import sqlline.OutputFile;
import sqlline.OutputFormat;
import sqlline.Quoting;
import sqlline.ReflectiveCommandHandler;
import sqlline.Reflector;
import sqlline.Rows;
import sqlline.SeparatedValuesOutputFormat;
import sqlline.SqlLineCommandCompleter;
import sqlline.SqlLineCompleter;
import sqlline.SqlLineOpts;
import sqlline.SqlLineSignalHandler;
import sqlline.TableNameCompleter;
import sqlline.TableOutputFormat;
import sqlline.VerticalOutputFormat;
import sqlline.XmlAttributeOutputFormat;
import sqlline.XmlElementOutputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlLine {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(SqlLine.class.getName());
    private static final String SEPARATOR = System.getProperty("line.separator");
    private boolean exit = false;
    private final DatabaseConnections connections = new DatabaseConnections();
    public static final String COMMAND_PREFIX = "!";
    private Set<Driver> drivers = null;
    private final SqlLineOpts opts = new SqlLineOpts(this, System.getProperties());
    private String lastProgress = null;
    private final Map<SQLWarning, Date> seenWarnings = new HashMap<SQLWarning, Date>();
    private final Commands commands = new Commands(this);
    private OutputFile scriptOutputFile = null;
    private OutputFile recordOutputFile = null;
    private PrintStream outputStream = new PrintStream(System.out, true);
    private PrintStream errorStream = new PrintStream(System.err, true);
    private ConsoleReader consoleReader;
    private List<String> batch = null;
    private final Reflector reflector;
    public static final String SQLLINE_BASE_DIR = "x.sqlline.basedir";
    static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static boolean initComplete = false;
    private SqlLineSignalHandler signalHandler = null;
    private final Completer sqlLineCommandCompleter;
    private final Map<String, OutputFormat> formats = SqlLine.map("vertical", new VerticalOutputFormat(this), "table", new TableOutputFormat(this), "csv", new SeparatedValuesOutputFormat(this, ','), "tsv", new SeparatedValuesOutputFormat(this, '\t'), "xmlattr", new XmlAttributeOutputFormat(this), "xmlelements", new XmlElementOutputFormat(this));
    final List<CommandHandler> commandHandlers;
    static final SortedSet<String> KNOWN_DRIVERS = new TreeSet<String>(Arrays.asList("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.informix.InformixDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.oracle.OracleDriver", "net.sourceforge.jtds.jdbc.Driver", "com.pointbase.jdbc.jdbcDriver", "com.internetcds.jdbc.tds.SybaseDriver", "org.enhydra.instantdb.jdbc.idbDriver", "com.sybase.jdbc2.jdbc.SybDriver", "com.ddtek.jdbc.sybase.SybaseDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.jnetdirect.jsql.JSQLDriver", "com.lucidera.jdbc.LucidDbRmiDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.hsqldb.jdbcDriver", "com.pointbase.jdbc.jdbcUniversalDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.oracle.OracleDriver", "oracle.jdbc.OracleDriver", "com.informix.jdbc.IfxDriver", "com.merant.datadirect.jdbc.informix.InformixDriver", "com.ibm.db2.jcc.DB2Driver", "com.pointbase.jdbc.jdbcEmbeddedDriver", "org.gjt.mm.mysql.Driver", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "interbase.interclient.Driver", "com.mysql.jdbc.NonRegisteringDriver", "com.merant.datadirect.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.sybase.SybaseDriver", "com.internetcds.jdbc.tds.Driver", "org.hsqldb.jdbcDriver", "org.hsql.jdbcDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.ddtek.jdbc.db2.DB2Driver", "interbase.interclient.Driver", "com.mysql.jdbc.Driver", "com.ddtek.jdbc.oracle.OracleDriver", "org.postgresql.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.jnetdirect.jsql.JSQLDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "weblogic.jdbc.mssqlserver4.Driver", "com.ddtek.jdbc.sybase.SybaseDriver", "oracle.jdbc.pool.OracleDataSource", "org.axiondb.jdbc.AxionDriver", "COM.ibm.db2.jdbc.app.DB2Driver", "com.ibm.as400.access.AS400JDBCDriver", "COM.FirstSQL.Dbcp.DbcpDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.enhydra.instantdb.jdbc.idbDriver", "com.informix.jdbc.IfxDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.imaginary.sql.msql.MsqlDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle.jdbc.driver.OracleDriver", "intersolv.jdbc.sequelink.SequeLinkDriver", "openlink.jdbc2.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "postgres95.PGDriver", "postgresql.Driver", "solid.jdbc.SolidDriver", "centura.java.sqlbase.SqlbaseDriver", "interbase.interclient.Driver", "com.mckoi.JDBCDriver", "com.inet.tds.TdsDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.thinweb.tds.Driver", "weblogic.jdbc.mssqlserver4.Driver", "com.mysql.jdbc.DatabaseMetaData", "org.gjt.mm.mysql.Driver", "com.sap.dbtech.jdbc.DriverSapDB", "com.sybase.jdbc2.jdbc.SybDriver", "com.sybase.jdbc.SybDriver", "com.internetcds.jdbc.tds.Driver", "weblogic.jdbc.pool.Driver", "com.sqlstream.jdbc.Driver", "org.luciddb.jdbc.LucidDbClientDriver"));
    private static final int SPACE = 0;
    private static final int DOT_SPACE = 1;
    private static final int QUOTED = 2;
    private static final int UNQUOTED = 3;

    static Manifest getManifest() throws IOException {
        URL base = SqlLine.class.getResource("/META-INF/MANIFEST.MF");
        URLConnection c = base.openConnection();
        if (c instanceof JarURLConnection) {
            return ((JarURLConnection)c).getManifest();
        }
        return null;
    }

    static String getManifestAttribute(String name) {
        try {
            Manifest m = SqlLine.getManifest();
            if (m == null) {
                return "??";
            }
            Attributes attrs = m.getAttributes("sqlline");
            if (attrs == null) {
                return "???";
            }
            String val = attrs.getValue(name);
            if (val == null || "".equals(val)) {
                return "????";
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "?????";
        }
    }

    String getApplicationTitle() {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/sqlline/sqlline/pom.properties");
        Properties properties = new Properties();
        properties.put("artifactId", "sqlline");
        properties.put("version", "???");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
        return this.loc("app-introduction", properties.getProperty("artifactId"), properties.getProperty("version"));
    }

    static String getApplicationContactInformation() {
        return SqlLine.getManifestAttribute("Implementation-Vendor");
    }

    String loc(String res, int param) {
        try {
            return MessageFormat.format(new ChoiceFormat(RESOURCE_BUNDLE.getString(res)).format(param), param);
        }
        catch (Exception e) {
            return res + ": " + param;
        }
    }

    String loc(String res, Object ... params) {
        return SqlLine.locStatic(RESOURCE_BUNDLE, this.getErrorStream(), res, params);
    }

    static String locStatic(ResourceBundle resourceBundle, PrintStream err, String res, Object ... params) {
        try {
            return MessageFormat.format(resourceBundle.getString(res), params);
        }
        catch (Exception e) {
            e.printStackTrace(err);
            try {
                return res + ": " + Arrays.toString(params);
            }
            catch (Exception e2) {
                return res;
            }
        }
    }

    protected String locElapsedTime(long milliseconds) {
        return this.loc("time-ms", (double)milliseconds / 1000.0);
    }

    public static void main(String[] args) throws IOException {
        SqlLine.start(args, null, true);
    }

    public static Status mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        return SqlLine.start(args, inputStream, false);
    }

    public SqlLine() {
        TableNameCompleter tableCompleter = new TableNameCompleter(this);
        List<Completer> empty = Collections.emptyList();
        this.commandHandlers = Arrays.asList(new ReflectiveCommandHandler(this, empty, "quit", "done", "exit"), new ReflectiveCommandHandler(this, new StringsCompleter(this.getConnectionURLExamples()), "connect", "open"), new ReflectiveCommandHandler(this, tableCompleter, "describe"), new ReflectiveCommandHandler(this, tableCompleter, "indexes"), new ReflectiveCommandHandler(this, tableCompleter, "primarykeys"), new ReflectiveCommandHandler(this, tableCompleter, "exportedkeys"), new ReflectiveCommandHandler(this, empty, "manual"), new ReflectiveCommandHandler(this, tableCompleter, "importedkeys"), new ReflectiveCommandHandler(this, empty, "procedures"), new ReflectiveCommandHandler(this, empty, "tables"), new ReflectiveCommandHandler(this, empty, "typeinfo"), new ReflectiveCommandHandler(this, tableCompleter, "columns"), new ReflectiveCommandHandler(this, empty, "reconnect"), new ReflectiveCommandHandler(this, tableCompleter, "dropall"), new ReflectiveCommandHandler(this, empty, "history"), new ReflectiveCommandHandler(this, new StringsCompleter(this.getMetadataMethodNames()), "metadata"), new ReflectiveCommandHandler(this, empty, "nativesql"), new ReflectiveCommandHandler(this, empty, "dbinfo"), new ReflectiveCommandHandler(this, empty, "rehash"), new ReflectiveCommandHandler(this, empty, "verbose"), new ReflectiveCommandHandler(this, new FileNameCompleter(), "run"), new ReflectiveCommandHandler(this, empty, "batch"), new ReflectiveCommandHandler(this, empty, "list"), new ReflectiveCommandHandler(this, empty, "all"), new ReflectiveCommandHandler(this, empty, "go", "#"), new ReflectiveCommandHandler(this, new FileNameCompleter(), "script"), new ReflectiveCommandHandler(this, new FileNameCompleter(), "record"), new ReflectiveCommandHandler(this, empty, "brief"), new ReflectiveCommandHandler(this, empty, "close"), new ReflectiveCommandHandler(this, empty, "closeall"), new ReflectiveCommandHandler(this, new StringsCompleter(this.getIsolationLevels()), "isolation"), new ReflectiveCommandHandler(this, new StringsCompleter(this.formats.keySet()), "outputformat"), new ReflectiveCommandHandler(this, empty, "autocommit"), new ReflectiveCommandHandler(this, empty, "commit"), new ReflectiveCommandHandler(this, new FileNameCompleter(), "properties"), new ReflectiveCommandHandler(this, empty, "rollback"), new ReflectiveCommandHandler(this, empty, "help", "?"), new ReflectiveCommandHandler(this, this.opts.optionCompleters(), "set"), new ReflectiveCommandHandler(this, empty, "save"), new ReflectiveCommandHandler(this, empty, "scan"), new ReflectiveCommandHandler(this, empty, "sql"), new ReflectiveCommandHandler(this, empty, "call"));
        this.sqlLineCommandCompleter = new SqlLineCommandCompleter(this);
        this.reflector = new Reflector(this);
        try {
            Class<?> handlerClass = Class.forName("sqlline.SunSignalHandler");
            this.signalHandler = (SqlLineSignalHandler)handlerClass.newInstance();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public static Status start(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        SqlLine sqlline = new SqlLine();
        Status status = sqlline.begin(args, inputStream, saveHistory);
        if (!Boolean.getBoolean("sqlline.system.exit")) {
            System.exit(status.ordinal());
        }
        return status;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.connections.current();
    }

    Connection getConnection() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        if (this.getDatabaseConnections().current().connection == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        return this.getDatabaseConnections().current().connection;
    }

    DatabaseMetaData getDatabaseMetaData() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        if (this.getDatabaseConnections().current().getDatabaseMetaData() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        return this.connections.current().getDatabaseMetaData();
    }

    public List<String> getIsolationLevels() {
        return Arrays.asList("TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE");
    }

    public Set<String> getMetadataMethodNames() {
        try {
            TreeSet<String> methodNames = new TreeSet<String>();
            for (Method method : DatabaseMetaData.class.getDeclaredMethods()) {
                methodNames.add(method.getName());
            }
            return methodNames;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    public List<String> getConnectionURLExamples() {
        return Arrays.asList("jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hsqldb:<database>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:luciddb:http://<hostname>", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>");
    }

    ColorBuffer getColorBuffer() {
        return new ColorBuffer(this.getOpts().getColor());
    }

    ColorBuffer getColorBuffer(String msg) {
        return new ColorBuffer(msg, this.getOpts().getColor());
    }

    void registerKnownDrivers() {
        for (String driverName : KNOWN_DRIVERS) {
            try {
                Class.forName(driverName);
            }
            catch (Throwable throwable) {}
        }
    }

    Status initArgs(String[] args, DispatchCallback callback) {
        LinkedList<String> commands = new LinkedList<String>();
        LinkedList<String> files = new LinkedList<String>();
        String driver = null;
        String user = null;
        String pass = null;
        String url = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                return Status.ARGS;
            }
            if (args[i].startsWith("--")) {
                boolean ret;
                String[] parts = this.split(args[i].substring(2), "=");
                this.debug(this.loc("setting-prop", Arrays.asList(parts)));
                if (parts.length <= 0 || (ret = parts.length >= 2 ? this.opts.set(parts[0], parts[1], true) : this.opts.set(parts[0], "true", true))) continue;
                return Status.ARGS;
            }
            if (args[i].equals("-d")) {
                driver = args[++i];
                continue;
            }
            if (args[i].equals("-n")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                pass = args[++i];
                continue;
            }
            if (args[i].equals("-u")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-e")) {
                commands.add(args[++i]);
                continue;
            }
            if (args[i].equals("-f")) {
                this.getOpts().setRun(args[++i]);
                continue;
            }
            files.add(args[i]);
        }
        if (url != null) {
            String com = "!connect " + url + " " + (user == null || user.length() == 0 ? "''" : user) + " " + (pass == null || pass.length() == 0 ? "''" : pass) + " " + (driver == null ? "" : driver);
            this.debug("issuing: " + com);
            this.dispatch(com, new DispatchCallback());
        }
        for (String file : files) {
            this.dispatch("!properties " + file, new DispatchCallback());
        }
        if (commands.size() > 0) {
            this.opts.setColor(false);
            this.opts.setHeaderInterval(-1);
            for (String command : commands) {
                this.debug(this.loc("executing-command", command));
                this.dispatch(command, new DispatchCallback());
            }
            this.exit = true;
        }
        Status status = Status.OK;
        if (this.opts.getRun() != null) {
            this.dispatch("!run " + this.opts.getRun(), callback);
            if (callback.isFailure()) {
                status = Status.OTHER;
            }
            this.dispatch("!quit", new DispatchCallback());
        }
        return status;
    }

    Status begin(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        ConsoleReader reader;
        boolean runningScript;
        try {
            this.opts.load();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        FileHistory fileHistory = new FileHistory(new File(this.opts.getHistoryFile()));
        boolean bl = runningScript = this.getOpts().getRun() != null;
        if (runningScript) {
            try {
                FileInputStream scriptStream = new FileInputStream(this.getOpts().getRun());
                reader = this.getConsoleReader(scriptStream, fileHistory);
            }
            catch (Throwable t) {
                this.handleException(t);
                this.commands.quit(null, new DispatchCallback());
                return Status.OTHER;
            }
        } else {
            reader = this.getConsoleReader(inputStream, fileHistory);
        }
        DispatchCallback callback = new DispatchCallback();
        Status status = this.initArgs(args, callback);
        switch (status) {
            case ARGS: {
                this.usage();
            }
            case OTHER: {
                return status;
            }
        }
        try {
            this.info(this.getApplicationTitle());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        initComplete = true;
        while (!this.exit) {
            try {
                this.signalHandler.setCallback(callback);
                this.dispatch(reader.readLine(this.getPrompt()), callback);
                if (saveHistory) {
                    fileHistory.flush();
                }
                if (callback.isSuccess() || !runningScript) continue;
                this.commands.quit(null, callback);
                status = Status.OTHER;
            }
            catch (EOFException eof) {
                this.commands.quit(null, callback);
            }
            catch (UserInterruptException ioe) {
                try {
                    callback.forceKillSqlQuery();
                    callback.setToCancel();
                    this.output(this.loc("command-canceled", new Object[0]));
                }
                catch (SQLException sqle) {
                    this.handleException(sqle);
                }
            }
            catch (Throwable t) {
                this.handleException(t);
                callback.setToFailure();
            }
        }
        this.commands.closeall(null, new DispatchCallback());
        if (callback.isFailure()) {
            status = Status.OTHER;
        }
        return status;
    }

    public ConsoleReader getConsoleReader(InputStream inputStream, FileHistory fileHistory) throws IOException {
        Terminal terminal = TerminalFactory.create();
        try {
            terminal.init();
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.toString());
            ioException.initCause(e);
            throw ioException;
        }
        this.consoleReader = inputStream != null ? new ConsoleReader(inputStream, System.out) : new ConsoleReader();
        this.consoleReader.addCompleter(new SqlLineCompleter(this));
        this.consoleReader.setHistory(fileHistory);
        this.consoleReader.setHandleUserInterrupt(true);
        this.consoleReader.setExpandEvents(false);
        return this.consoleReader;
    }

    void usage() {
        this.output(this.loc("cmd-usage", new Object[0]));
    }

    void dispatch(String line, DispatchCallback callback) {
        if (line == null) {
            this.exit = true;
            return;
        }
        if (line.trim().length() == 0) {
            return;
        }
        if (this.isComment(line)) {
            return;
        }
        line = line.trim();
        if (this.scriptOutputFile != null) {
            this.scriptOutputFile.addLine(line);
        }
        if (this.isHelpRequest(line)) {
            line = "!help";
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            TreeMap<String, CommandHandler> cmdMap = new TreeMap<String, CommandHandler>();
            line = line.substring(1);
            for (CommandHandler commandHandler : this.commandHandlers) {
                String match = commandHandler.matches(line);
                if (match == null) continue;
                cmdMap.put(match, commandHandler);
            }
            if (cmdMap.size() == 0) {
                callback.setStatus(DispatchCallback.Status.FAILURE);
                this.error(this.loc("unknown-command", line));
            } else if (cmdMap.size() > 1) {
                callback.setStatus(DispatchCallback.Status.FAILURE);
                this.error(this.loc("multiple-matches", cmdMap.keySet().toString()));
            } else {
                callback.setStatus(DispatchCallback.Status.RUNNING);
                ((CommandHandler)cmdMap.values().iterator().next()).execute(line, callback);
            }
        } else {
            callback.setStatus(DispatchCallback.Status.RUNNING);
            this.commands.sql(line, callback);
        }
    }

    boolean needsContinuation(String line) {
        if (null == line) {
            return false;
        }
        if (this.isHelpRequest(line)) {
            return false;
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            return false;
        }
        if (this.isComment(line)) {
            return false;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        return !trimmed.endsWith(";");
    }

    boolean isHelpRequest(String line) {
        return line.equals("?") || line.equalsIgnoreCase("help");
    }

    boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--");
    }

    void output(String msg) {
        this.output(msg, true);
    }

    void info(String msg) {
        if (!this.opts.getSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    void info(ColorBuffer msg) {
        if (!this.opts.getSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    boolean error(String msg) {
        this.output(this.getColorBuffer().red(msg), true, this.errorStream);
        return false;
    }

    boolean error(Throwable t) {
        this.handleException(t);
        return false;
    }

    void debug(String msg) {
        if (this.opts.getVerbose()) {
            this.output(this.getColorBuffer().blue(msg), true, this.errorStream);
        }
    }

    void output(ColorBuffer msg) {
        this.output(msg, true);
    }

    void output(String msg, boolean newline, PrintStream out) {
        this.output(this.getColorBuffer(msg), newline, out);
    }

    void output(ColorBuffer msg, boolean newline) {
        this.output(msg, newline, this.getOutputStream());
    }

    void output(ColorBuffer msg, boolean newline, PrintStream out) {
        if (newline) {
            out.println(msg.getColor());
        } else {
            out.print(msg.getColor());
        }
        if (this.recordOutputFile == null) {
            return;
        }
        if (newline) {
            this.recordOutputFile.addLine(msg.getMono());
        }
    }

    void output(String msg, boolean newline) {
        this.output(this.getColorBuffer(msg), newline);
    }

    void autocommitStatus(Connection c) throws SQLException {
        this.debug(this.loc("autocommit-status", c.getAutoCommit() + ""));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.getDatabaseConnection().connection.getAutoCommit()) {
                return this.error(this.loc("autocommit-needs-off", new Object[0]));
            }
        }
        catch (Exception e) {
            return this.error(e);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.getDatabaseConnection() == null || this.getDatabaseConnection().connection == null) {
                return this.error(this.loc("no-current-connection", new Object[0]));
            }
            if (this.getDatabaseConnection().connection.isClosed()) {
                return this.error(this.loc("connection-is-closed", new Object[0]));
            }
        }
        catch (SQLException sqle) {
            return this.error(this.loc("no-current-connection", new Object[0]));
        }
        return true;
    }

    void showWarnings() {
        if (this.getDatabaseConnection().connection == null) {
            return;
        }
        if (!this.opts.getShowWarnings()) {
            return;
        }
        try {
            this.showWarnings(this.getDatabaseConnection().connection.getWarnings());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void showWarnings(SQLWarning warn) {
        SQLWarning next;
        if (warn == null) {
            return;
        }
        if (this.seenWarnings.get(warn) == null) {
            this.seenWarnings.put(warn, new Date());
            this.handleSQLException(warn);
        }
        if ((next = warn.getNextWarning()) != warn) {
            this.showWarnings(next);
        }
    }

    String getPrompt() {
        DatabaseConnection dbc = this.getDatabaseConnection();
        if (dbc == null || dbc.getUrl() == null) {
            return "sqlline> ";
        }
        return SqlLine.getPrompt(this.connections.getIndex() + ": " + dbc.getUrl()) + "> ";
    }

    static String getPrompt(String url) {
        if (url == null || url.length() == 0) {
            url = "sqlline";
        }
        if (url.contains(";")) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.length() > 45) {
            url = url.substring(0, 45);
        }
        return url;
    }

    int getSize(ResultSet rs) {
        try {
            if (rs.getType() == 1003) {
                return -1;
            }
            rs.last();
            int total = rs.getRow();
            rs.beforeFirst();
            return total;
        }
        catch (SQLException sqle) {
            return -1;
        }
        catch (AbstractMethodError ame) {
            return -1;
        }
    }

    ResultSet getColumns(String table) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().meta.getColumns(this.getDatabaseConnection().meta.getConnection().getCatalog(), null, table, "%");
    }

    ResultSet getTables() throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().meta.getTables(this.getDatabaseConnection().meta.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getColumnNames(DatabaseMetaData meta) throws SQLException {
        HashSet<String> names = new HashSet<String>();
        this.info(this.loc("building-tables", new Object[0]));
        try {
            ResultSet columns = this.getColumns("%");
            try {
                int total = this.getSize(columns);
                int index = 0;
                while (columns.next()) {
                    this.progress(index++, total);
                    String tableName = columns.getString("TABLE_NAME");
                    String columnName = columns.getString("COLUMN_NAME");
                    names.add(tableName);
                    names.add(columnName);
                    names.add(tableName + "." + columnName);
                }
                this.progress(index, index);
            }
            finally {
                columns.close();
            }
            this.info(this.loc("done", new Object[0]));
            return names;
        }
        catch (Throwable t) {
            this.handleException(t);
            return Collections.emptySet();
        }
    }

    String[] split(String line) {
        return this.split(line, " ");
    }

    public String[][] splitCompound(String line) {
        int n;
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        Quoting quoting = databaseConnection == null ? Quoting.DEFAULT : databaseConnection.quoting;
        int state = 0;
        int idStart = -1;
        char[] chars = line.toCharArray();
        for (n = chars.length; n > 0 && (Character.isWhitespace(chars[n - 1]) || chars[n - 1] == ';'); --n) {
        }
        ArrayList<String[]> words = new ArrayList<String[]>();
        ArrayList<String> current = new ArrayList<String>();
        int i = 0;
        block10: while (i < n) {
            char c = chars[i];
            switch (state) {
                case 0: 
                case 1: {
                    ++i;
                    if (Character.isWhitespace(c)) break;
                    if (c == '.') {
                        state = 1;
                        break;
                    }
                    if (c == quoting.start) {
                        if (state == 0 && current.size() > 0) {
                            words.add(current.toArray(new String[current.size()]));
                            current.clear();
                        }
                        state = 2;
                        idStart = i;
                        break;
                    }
                    if (state == 0 && current.size() > 0) {
                        words.add(current.toArray(new String[current.size()]));
                        current.clear();
                    }
                    state = 3;
                    idStart = i - 1;
                    break;
                }
                case 2: {
                    ++i;
                    if (c != quoting.end) continue block10;
                    if (i < n && chars[i] == quoting.end) {
                        System.arraycopy(chars, i, chars, i - 1, n - i);
                        --n;
                        break;
                    }
                    state = 0;
                    String word = new String(chars, idStart, i - idStart - 1);
                    current.add(word);
                    break;
                }
                case 3: {
                    ++i;
                    if (!Character.isWhitespace(c) && c != '.') continue block10;
                    String word = new String(chars, idStart, i - idStart - 1);
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (quoting.upper) {
                        word = word.toUpperCase();
                    }
                    current.add(word);
                    state = c == '.' ? 1 : 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state " + state));
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String word = new String(chars, idStart, n - idStart);
                if (state == 3) {
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (quoting.upper) {
                        word = word.toUpperCase();
                    }
                }
                current.add(word);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected state " + state));
            }
        }
        if (current.size() > 0) {
            words.add(current.toArray(new String[current.size()]));
        }
        return (String[][])words.toArray((T[])new String[words.size()][]);
    }

    String dequote(String str) {
        if (str == null) {
            return null;
        }
        while (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    String[] split(String line, String delim) {
        StringTokenizer tok = new StringTokenizer(line, delim);
        String[] ret = new String[tok.countTokens()];
        int index = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            t = this.dequote(t);
            ret[index++] = t;
        }
        return ret;
    }

    static <K, V> Map<K, V> map(K key, V value, Object ... obs) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(key, value);
        for (int i = 0; i < obs.length - 1; i += 2) {
            m.put(obs[i], obs[i + 1]);
        }
        return Collections.unmodifiableMap(m);
    }

    static boolean getMoreResults(Statement stmnt) {
        try {
            return stmnt.getMoreResults();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static String xmlattrencode(String str) {
        str = SqlLine.replace(str, "\"", "&quot;");
        str = SqlLine.replace(str, "<", "&lt;");
        return str;
    }

    static String replace(String source, String from, String to) {
        int index;
        if (source == null) {
            return null;
        }
        if (from.equals(to)) {
            return source;
        }
        StringBuilder replaced = new StringBuilder();
        while ((index = source.indexOf(from)) != -1) {
            replaced.append(source.substring(0, index));
            replaced.append(to);
            source = source.substring(index + from.length());
        }
        replaced.append(source);
        return replaced.toString();
    }

    String[] split(String line, int assertLen, String usage) {
        String[] ret = this.split(line);
        if (ret.length != assertLen) {
            this.error(usage);
            return null;
        }
        return ret;
    }

    String wrap(String toWrap, int len, int start) {
        StringBuilder buff = new StringBuilder();
        StringBuilder line = new StringBuilder();
        char[] head = new char[start];
        Arrays.fill(head, ' ');
        StringTokenizer tok = new StringTokenizer(toWrap, " ");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (line.length() + next.length() > len) {
                buff.append((CharSequence)line).append(SEPARATOR).append(head);
                line.setLength(0);
            }
            line.append(line.length() == 0 ? "" : " ").append(next);
        }
        buff.append((CharSequence)line);
        return buff.toString();
    }

    void progress(int cur, int max) {
        StringBuilder out = new StringBuilder();
        if (this.lastProgress != null) {
            char[] back = new char[this.lastProgress.length()];
            Arrays.fill(back, '\b');
            out.append(back);
        }
        String progress = cur + "/" + (max == -1 ? "?" : "" + max) + " " + (max == -1 ? "(??%)" : "(" + cur * 100 / (max == 0 ? 1 : max) + "%)");
        if (cur >= max && max != -1) {
            progress = progress + " " + this.loc("done", new Object[0]) + SEPARATOR;
            this.lastProgress = null;
        } else {
            this.lastProgress = progress;
        }
        out.append(progress);
        this.getOutputStream().print(out.toString());
        this.getOutputStream().flush();
    }

    void handleException(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof SQLException) {
            this.handleSQLException((SQLException)e);
        } else if (!initComplete && !this.opts.getVerbose()) {
            if (e.getMessage() == null) {
                this.error(e.getClass().getName());
            } else {
                this.error(e.getMessage());
            }
        } else {
            e.printStackTrace(System.err);
        }
    }

    void handleSQLException(SQLException e) {
        boolean showNested;
        boolean showWarnings = !initComplete || this.opts.getShowWarnings();
        boolean verbose = !initComplete || this.opts.getVerbose();
        boolean bl = showNested = !initComplete || this.opts.getShowNestedErrs();
        if (e instanceof SQLWarning && !showWarnings) {
            return;
        }
        String type = e instanceof SQLWarning ? this.loc("Warning", new Object[0]) : this.loc("Error", new Object[0]);
        this.error(this.loc(e instanceof SQLWarning ? "Warning" : "Error", e.getMessage() == null ? "" : e.getMessage().trim(), e.getSQLState() == null ? "" : e.getSQLState().trim(), e.getErrorCode()));
        if (verbose) {
            e.printStackTrace();
        }
        if (!showNested) {
            return;
        }
        for (SQLException nested = e.getNextException(); nested != null && nested != e; nested = nested.getNextException()) {
            this.handleSQLException(nested);
        }
    }

    boolean scanForDriver(String url) {
        try {
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(true);
            if (this.findRegisteredDriver(url) != null) {
                return true;
            }
            this.scanDrivers(false);
            return this.findRegisteredDriver(url) != null;
        }
        catch (Exception e) {
            this.debug(e.toString());
            return false;
        }
    }

    private Driver findRegisteredDriver(String url) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    Set<Driver> scanDrivers(String line) throws IOException {
        return this.scanDrivers(false);
    }

    Set<Driver> scanDrivers(boolean knownOnly) throws IOException {
        long start = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        if (!knownOnly) {
            classNames.addAll(ClassNameCompleter.getClassNames());
        }
        classNames.addAll(KNOWN_DRIVERS);
        HashSet<Driver> driverClasses = new HashSet<Driver>();
        for (String className : classNames) {
            if (!className.toLowerCase().contains("driver")) continue;
            try {
                Class<?> c = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                if (!Driver.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                driverClasses.add((Driver)c.newInstance());
            }
            catch (Throwable t) {}
        }
        long end = System.currentTimeMillis();
        this.info("scan complete in " + (end - start) + "ms");
        return driverClasses;
    }

    int print(ResultSet rs, DispatchCallback callback) throws SQLException {
        String format = this.opts.getOutputFormat();
        OutputFormat f = this.formats.get(format);
        if (f == null) {
            this.error(this.loc("unknown-format", format, this.formats.keySet()));
            f = new TableOutputFormat(this);
        }
        Rows rows = this.opts.getIncremental() ? new IncrementalRows(this, rs, callback) : new BufferedRows(this, rs);
        return f.print(rows);
    }

    Statement createStatement() throws SQLException {
        Statement stmnt = this.getDatabaseConnection().connection.createStatement();
        if (this.opts.timeout > -1) {
            stmnt.setQueryTimeout(this.opts.timeout);
        }
        if (this.opts.rowLimit != 0) {
            stmnt.setMaxRows(this.opts.rowLimit);
        }
        return stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatch(List<String> statements) {
        try {
            Statement stmnt = this.createStatement();
            try {
                for (String statement : statements) {
                    stmnt.addBatch(statement);
                }
                int[] counts = stmnt.executeBatch();
                if (counts == null) {
                    counts = new int[]{};
                }
                this.output(this.getColorBuffer().pad(this.getColorBuffer().bold("COUNT"), 8).append(this.getColorBuffer().bold("STATEMENT")));
                for (int i = 0; i < counts.length; ++i) {
                    this.output(this.getColorBuffer().pad(counts[i] + "", 8).append(statements.get(i)));
                }
            }
            finally {
                try {
                    stmnt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int runCommands(List<String> cmds, DispatchCallback callback) {
        int successCount = 0;
        try {
            int index = 1;
            int size = cmds.size();
            for (String cmd : cmds) {
                this.info(this.getColorBuffer().pad(index++ + "/" + size, 13).append(cmd));
                this.dispatch(cmd, callback);
                boolean success = callback.isSuccess();
                if (!success && !this.opts.getForce()) {
                    this.error(this.loc("abort-on-error", cmd));
                    return successCount;
                }
                successCount += success ? 1 : 0;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return successCount;
    }

    void setCompletions() throws SQLException, IOException {
        if (this.getDatabaseConnection() != null) {
            this.getDatabaseConnection().setCompletions(this.opts.getFastConnect());
        }
    }

    public SqlLineOpts getOpts() {
        return this.opts;
    }

    DatabaseConnections getDatabaseConnections() {
        return this.connections;
    }

    public boolean isExit() {
        return this.exit;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    Set<Driver> getDrivers() {
        return this.drivers;
    }

    void setDrivers(Set<Driver> drivers) {
        this.drivers = drivers;
    }

    public static String getSeparator() {
        return SEPARATOR;
    }

    Commands getCommands() {
        return this.commands;
    }

    OutputFile getScriptOutputFile() {
        return this.scriptOutputFile;
    }

    void setScriptOutputFile(OutputFile script) {
        this.scriptOutputFile = script;
    }

    OutputFile getRecordOutputFile() {
        return this.recordOutputFile;
    }

    void setRecordOutputFile(OutputFile record) {
        this.recordOutputFile = record;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = new PrintStream(outputStream, true);
    }

    PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = new PrintStream(errorStream, true);
    }

    PrintStream getErrorStream() {
        return this.errorStream;
    }

    ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    void setConsoleReader(ConsoleReader reader) {
        this.consoleReader = reader;
    }

    List<String> getBatch() {
        return this.batch;
    }

    void setBatch(List<String> batch) {
        this.batch = batch;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public Completer getCommandCompleter() {
        return this.sqlLineCommandCompleter;
    }

    static {
        String testClass = "jline.console.ConsoleReader";
        try {
            Class.forName(testClass);
        }
        catch (Throwable t) {
            String message = SqlLine.locStatic(RESOURCE_BUNDLE, System.err, "jline-missing", testClass);
            throw new ExceptionInInitializerError(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK,
        ARGS,
        OTHER;

    }
}

