/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;

class RemoteMeta
extends MetaImpl {
    final Service service;
    final Map<String, ConnectionPropertiesImpl> propsMap = new HashMap<String, ConnectionPropertiesImpl>();
    private Map<Meta.DatabaseProperty, Object> databaseProperties;

    public RemoteMeta(AvaticaConnection connection, Service service) {
        super(connection);
        this.service = service;
    }

    private Meta.MetaResultSet toResultSet(Class clazz, Service.ResultSetResponse response) {
        if (response.updateCount != -1L) {
            return Meta.MetaResultSet.count(response.connectionId, response.statementId, response.updateCount);
        }
        Meta.Signature signature0 = response.signature;
        if (signature0 == null) {
            List<ColumnMetaData> columns = clazz == null ? Collections.emptyList() : RemoteMeta.fieldMetaData((Class)clazz).columns;
            signature0 = Meta.Signature.create(columns, "?", Collections.emptyList(), Meta.CursorFactory.ARRAY, Meta.StatementType.SELECT);
        }
        return Meta.MetaResultSet.create(response.connectionId, response.statementId, response.ownStatement, signature0, response.firstFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        RemoteMeta remoteMeta = this;
        synchronized (remoteMeta) {
            if (this.databaseProperties == null) {
                this.databaseProperties = this.service.apply((Service.DatabasePropertyRequest)new Service.DatabasePropertyRequest((String)ch.id)).map;
            }
            return this.databaseProperties;
        }
    }

    @Override
    public Meta.StatementHandle createStatement(final Meta.ConnectionHandle ch) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.StatementHandle>(){

            @Override
            public Meta.StatementHandle call() {
                RemoteMeta.this.connectionSync(ch, new ConnectionPropertiesImpl());
                Service.CreateStatementResponse response = RemoteMeta.this.service.apply(new Service.CreateStatementRequest(ch.id));
                return new Meta.StatementHandle(response.connectionId, response.statementId, null);
            }
        });
    }

    @Override
    public void closeStatement(final Meta.StatementHandle h) {
        this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Void>(){

            @Override
            public Void call() {
                Service.CloseStatementResponse response = RemoteMeta.this.service.apply(new Service.CloseStatementRequest(h.connectionId, h.id));
                return null;
            }
        });
    }

    @Override
    public void openConnection(final Meta.ConnectionHandle ch, final Map<String, String> info) {
        this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Void>(){

            @Override
            public Void call() {
                Service.OpenConnectionResponse response = RemoteMeta.this.service.apply(new Service.OpenConnectionRequest(ch.id, info));
                return null;
            }
        });
    }

    @Override
    public void closeConnection(final Meta.ConnectionHandle ch) {
        this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Void>(){

            @Override
            public Void call() {
                Service.CloseConnectionResponse response = RemoteMeta.this.service.apply(new Service.CloseConnectionRequest(ch.id));
                RemoteMeta.this.propsMap.remove(ch.id);
                return null;
            }
        });
    }

    @Override
    public Meta.ConnectionProperties connectionSync(final Meta.ConnectionHandle ch, final Meta.ConnectionProperties connProps) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.ConnectionProperties>(){

            @Override
            public Meta.ConnectionProperties call() {
                ConnectionPropertiesImpl localProps = RemoteMeta.this.propsMap.get(ch.id);
                if (localProps == null) {
                    localProps = new ConnectionPropertiesImpl();
                    localProps.setDirty(true);
                    RemoteMeta.this.propsMap.put(ch.id, localProps);
                }
                if (localProps.merge(connProps).isDirty() && connProps.isEmpty()) {
                    Service.ConnectionSyncResponse response = RemoteMeta.this.service.apply(new Service.ConnectionSyncRequest(ch.id, localProps));
                    RemoteMeta.this.propsMap.put(ch.id, (ConnectionPropertiesImpl)response.connProps);
                    return response.connProps;
                }
                return localProps;
            }
        });
    }

    @Override
    public Meta.MetaResultSet getCatalogs(final Meta.ConnectionHandle ch) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.CatalogsRequest(ch.id));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaCatalog.class, response);
            }
        });
    }

    @Override
    public Meta.MetaResultSet getSchemas(final Meta.ConnectionHandle ch, final String catalog, final Meta.Pat schemaPattern) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.SchemasRequest(ch.id, catalog, schemaPattern.s));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaSchema.class, response);
            }
        });
    }

    @Override
    public Meta.MetaResultSet getTables(final Meta.ConnectionHandle ch, final String catalog, final Meta.Pat schemaPattern, final Meta.Pat tableNamePattern, final List<String> typeList) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.TablesRequest(ch.id, catalog, schemaPattern.s, tableNamePattern.s, typeList));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaTable.class, response);
            }
        });
    }

    @Override
    public Meta.MetaResultSet getTableTypes(final Meta.ConnectionHandle ch) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.TableTypesRequest(ch.id));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaTableType.class, response);
            }
        });
    }

    @Override
    public Meta.MetaResultSet getTypeInfo(final Meta.ConnectionHandle ch) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.TypeInfoRequest(ch.id));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaTypeInfo.class, response);
            }
        });
    }

    @Override
    public Meta.MetaResultSet getColumns(final Meta.ConnectionHandle ch, final String catalog, final Meta.Pat schemaPattern, final Meta.Pat tableNamePattern, final Meta.Pat columnNamePattern) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.MetaResultSet>(){

            @Override
            public Meta.MetaResultSet call() {
                Service.ResultSetResponse response = RemoteMeta.this.service.apply(new Service.ColumnsRequest(ch.id, catalog, schemaPattern.s, tableNamePattern.s, columnNamePattern.s));
                return RemoteMeta.this.toResultSet(MetaImpl.MetaColumn.class, response);
            }
        });
    }

    @Override
    public Meta.StatementHandle prepare(final Meta.ConnectionHandle ch, final String sql, final long maxRowCount) {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.StatementHandle>(){

            @Override
            public Meta.StatementHandle call() {
                RemoteMeta.this.connectionSync(ch, new ConnectionPropertiesImpl());
                Service.PrepareResponse response = RemoteMeta.this.service.apply(new Service.PrepareRequest(ch.id, sql, maxRowCount));
                return response.statement;
            }
        });
    }

    @Override
    public Meta.ExecuteResult prepareAndExecute(final Meta.StatementHandle h, final String sql, final long maxRowCount, final Meta.PrepareCallback callback) throws NoSuchStatementException {
        try {
            return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.ExecuteResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Meta.ExecuteResult call() {
                    RemoteMeta.this.connectionSync(new Meta.ConnectionHandle(h.connectionId), new ConnectionPropertiesImpl());
                    try {
                        Service.ExecuteResponse response;
                        Object object = callback.getMonitor();
                        synchronized (object) {
                            callback.clear();
                            response = RemoteMeta.this.service.apply(new Service.PrepareAndExecuteRequest(h.connectionId, h.id, sql, maxRowCount));
                            if (response.missingStatement) {
                                throw new RuntimeException(new NoSuchStatementException(h));
                            }
                            if (response.results.size() > 0) {
                                Service.ResultSetResponse result = response.results.get(0);
                                callback.assign(result.signature, result.firstFrame, result.updateCount);
                            }
                        }
                        callback.execute();
                        ArrayList<Meta.MetaResultSet> metaResultSets = new ArrayList<Meta.MetaResultSet>();
                        for (Service.ResultSetResponse result : response.results) {
                            metaResultSets.add(RemoteMeta.this.toResultSet(null, result));
                        }
                        return new Meta.ExecuteResult(metaResultSets);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchStatementException) {
                throw (NoSuchStatementException)cause;
            }
            throw e;
        }
    }

    @Override
    public Meta.Frame fetch(final Meta.StatementHandle h, final long offset, final int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        try {
            return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.Frame>(){

                @Override
                public Meta.Frame call() {
                    Service.FetchResponse response = RemoteMeta.this.service.apply(new Service.FetchRequest(h.connectionId, h.id, offset, fetchMaxRowCount));
                    if (response.missingStatement) {
                        throw new RuntimeException(new NoSuchStatementException(h));
                    }
                    if (response.missingResults) {
                        throw new RuntimeException(new MissingResultsException(h));
                    }
                    return response.frame;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchStatementException) {
                throw (NoSuchStatementException)cause;
            }
            if (cause instanceof MissingResultsException) {
                throw (MissingResultsException)cause;
            }
            throw e;
        }
    }

    @Override
    public Meta.ExecuteResult execute(final Meta.StatementHandle h, final List<TypedValue> parameterValues, final long maxRowCount) throws NoSuchStatementException {
        try {
            return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.ExecuteResult>(){

                @Override
                public Meta.ExecuteResult call() {
                    Service.ExecuteResponse response = RemoteMeta.this.service.apply(new Service.ExecuteRequest(h, parameterValues, maxRowCount));
                    if (response.missingStatement) {
                        throw new RuntimeException(new NoSuchStatementException(h));
                    }
                    ArrayList<Meta.MetaResultSet> metaResultSets = new ArrayList<Meta.MetaResultSet>();
                    for (Service.ResultSetResponse result : response.results) {
                        metaResultSets.add(RemoteMeta.this.toResultSet(null, result));
                    }
                    return new Meta.ExecuteResult(metaResultSets);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchStatementException) {
                throw (NoSuchStatementException)cause;
            }
            throw e;
        }
    }

    @Override
    public boolean syncResults(final Meta.StatementHandle h, final QueryState state, final long offset) throws NoSuchStatementException {
        try {
            return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Boolean>(){

                @Override
                public Boolean call() {
                    Service.SyncResultsResponse response = RemoteMeta.this.service.apply(new Service.SyncResultsRequest(h.connectionId, h.id, state, offset));
                    if (response.missingStatement) {
                        throw new RuntimeException(new NoSuchStatementException(h));
                    }
                    return response.moreResults;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchStatementException) {
                throw (NoSuchStatementException)cause;
            }
            throw e;
        }
    }

    @Override
    public void commit(final Meta.ConnectionHandle ch) {
        this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Void>(){

            @Override
            public Void call() {
                Service.CommitResponse response = RemoteMeta.this.service.apply(new Service.CommitRequest(ch.id));
                return null;
            }
        });
    }

    @Override
    public void rollback(final Meta.ConnectionHandle ch) {
        this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Void>(){

            @Override
            public Void call() {
                Service.RollbackResponse response = RemoteMeta.this.service.apply(new Service.RollbackRequest(ch.id));
                return null;
            }
        });
    }

    @Override
    public Meta.ExecuteBatchResult prepareAndExecuteBatch(final Meta.StatementHandle h, final List<String> sqlCommands) throws NoSuchStatementException {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.ExecuteBatchResult>(){

            @Override
            public Meta.ExecuteBatchResult call() {
                Service.ExecuteBatchResponse response = RemoteMeta.this.service.apply(new Service.PrepareAndExecuteBatchRequest(h.connectionId, h.id, sqlCommands));
                return new Meta.ExecuteBatchResult(response.updateCounts);
            }
        });
    }

    @Override
    public Meta.ExecuteBatchResult executeBatch(final Meta.StatementHandle h, final List<List<TypedValue>> parameterValues) throws NoSuchStatementException {
        return this.connection.invokeWithRetries(new AvaticaConnection.CallableWithoutException<Meta.ExecuteBatchResult>(){

            @Override
            public Meta.ExecuteBatchResult call() {
                Service.ExecuteBatchResponse response = RemoteMeta.this.service.apply(new Service.ExecuteBatchRequest(h.connectionId, h.id, parameterValues));
                return new Meta.ExecuteBatchResult(response.updateCounts);
            }
        });
    }
}

