/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;

public final class QueryUtil {
    private static final Log LOG = LogFactory.getLog(QueryUtil.class);
    public static final int COLUMN_FAMILY_POSITION = 25;
    public static final int COLUMN_NAME_POSITION = 4;
    public static final int DATA_TYPE_POSITION = 5;
    public static final int DATA_TYPE_NAME_POSITION = 6;
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String WHERE = "WHERE";
    private static final String[] CompareOpString = new String[CompareFilter.CompareOp.values().length];

    public static String toSQL(CompareFilter.CompareOp op) {
        return CompareOpString[op.ordinal()];
    }

    private QueryUtil() {
    }

    public static String constructUpsertStatement(String tableName, List<ColumnInfo> columnInfos) {
        if (columnInfos.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        List<String> columnNames = Lists.transform(columnInfos, new Function<ColumnInfo, String>(){

            @Override
            public String apply(ColumnInfo columnInfo) {
                return columnInfo.getColumnName();
            }
        });
        return QueryUtil.constructUpsertStatement(tableName, columnNames, null);
    }

    public static String constructUpsertStatement(String tableName, List<String> columns, HintNode.Hint hint) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        String hintStr = "";
        if (hint != null) {
            HintNode node = new HintNode(hint.name());
            hintStr = node.toString();
        }
        ArrayList<String> parameterList = Lists.newArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT %s INTO %s (%s) VALUES (%s)", hintStr, tableName, Joiner.on(", ").join(Iterables.transform(columns, new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String columnName) {
                return SchemaUtil.getEscapedFullColumnName(columnName);
            }
        })), Joiner.on(", ").join(parameterList));
    }

    public static String constructGenericUpsertStatement(String tableName, int numColumns) {
        if (numColumns == 0) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        ArrayList<String> parameterList = Lists.newArrayListWithCapacity(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT INTO %s VALUES (%s)", tableName, Joiner.on(", ").join(parameterList));
    }

    public static String constructSelectStatement(String fullTableName, List<ColumnInfo> columnInfos, String conditions) {
        Preconditions.checkNotNull(fullTableName, "Table name cannot be null");
        if (columnInfos == null || columnInfos.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided");
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        for (ColumnInfo cinfo : columnInfos) {
            if (cinfo == null) continue;
            String fullColumnName = SchemaUtil.getEscapedFullColumnName(cinfo.getColumnName());
            query.append(fullColumnName);
            query.append(",");
        }
        query.setLength(query.length() - 1);
        query.append(" FROM ");
        query.append(fullTableName);
        if (conditions != null && conditions.length() > 0) {
            query.append(" WHERE (").append(conditions).append(")");
        }
        return query.toString();
    }

    public static String getUrl(String zkQuorum) {
        return QueryUtil.getUrlInternal(zkQuorum, null, null);
    }

    public static String getUrl(String zkQuorum, int clientPort) {
        return QueryUtil.getUrlInternal(zkQuorum, clientPort, null);
    }

    public static String getUrl(String zkQuorum, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, null, znodeParent);
    }

    public static String getUrl(String zkQuorum, int port, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent);
    }

    public static String getUrl(String zkQuorum, Integer port, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent);
    }

    private static String getUrlInternal(String zkQuorum, Integer port, String znodeParent) {
        return new PhoenixEmbeddedDriver.ConnectionInfo(zkQuorum, port, znodeParent).toUrl() + ';';
    }

    public static String getExplainPlan(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (rs.next()) {
            buf.append(rs.getString(1));
            buf.append('\n');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String getExplainPlan(ResultIterator iterator) throws SQLException {
        ArrayList<String> steps = Lists.newArrayList();
        iterator.explain(steps);
        StringBuilder buf = new StringBuilder();
        for (String step : steps) {
            buf.append(step);
            buf.append('\n');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static Connection getConnection(Configuration conf) throws ClassNotFoundException, SQLException {
        return QueryUtil.getConnection(new Properties(), conf);
    }

    public static Connection getConnection(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        String url = QueryUtil.getConnectionUrl(props, conf);
        LOG.info("Creating connection with the jdbc url: " + url);
        PropertiesUtil.extractProperties(props, conf);
        return DriverManager.getConnection(url, props);
    }

    public static String getConnectionUrl(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        Class.forName(PhoenixDriver.class.getName());
        String server = ZKConfig.getZKQuorumServersString(conf);
        String[] rawServers = server.split(",");
        ArrayList<String> servers = new ArrayList<String>(rawServers.length);
        boolean first = true;
        int port = -1;
        for (String serverPort : rawServers) {
            try {
                server = Addressing.parseHostname(serverPort);
                int specifiedPort = Addressing.parsePort(serverPort);
                if (port > 0 && specifiedPort != port) {
                    throw new IllegalStateException("Phoenix/HBase only supports connecting to a single zookeeper client port. Specify servers only as host names in HBase configuration");
                }
                port = specifiedPort;
                servers.add(server);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (port == -1 && (port = conf.getInt("hbase.zookeeper.property.clientPort", -1)) == -1) {
            throw new RuntimeException("Client zk port was not set!");
        }
        server = Joiner.on(',').join(servers);
        String znodeParent = conf.get("zookeeper.znode.parent", "/hbase");
        return QueryUtil.getUrl(server, port, znodeParent);
    }

    public static String getViewStatement(String schemaName, String tableName, String where) {
        return "SELECT * FROM " + (schemaName == null || schemaName.length() == 0 ? "" : "\"" + schemaName + "\".") + "\"" + tableName + "\" " + "WHERE " + where;
    }

    static {
        QueryUtil.CompareOpString[CompareFilter.CompareOp.EQUAL.ordinal()] = "=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.NOT_EQUAL.ordinal()] = "!=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.GREATER.ordinal()] = ">";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.LESS.ordinal()] = "<";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.GREATER_OR_EQUAL.ordinal()] = ">=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.LESS_OR_EQUAL.ordinal()] = "<=";
    }
}

