/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.visitor.RowKeyExpressionVisitor;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexUtil {
    public static final String INDEX_COLUMN_NAME_SEP = ":";
    public static final byte[] INDEX_COLUMN_NAME_SEP_BYTES = Bytes.toBytes(":");

    private IndexUtil() {
    }

    public static PDataType getIndexColumnDataType(PColumn dataColumn) throws SQLException {
        PDataType type = IndexUtil.getIndexColumnDataType(dataColumn.isNullable(), dataColumn.getDataType());
        if (type == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_INDEX_COLUMN_ON_TYPE).setColumnName(dataColumn.getName().getString()).setMessage("Type=" + dataColumn.getDataType()).build().buildException();
        }
        return type;
    }

    public static PDataType getIndexColumnDataType(boolean isNullable, PDataType dataType) {
        if (dataType == null || !isNullable || !dataType.isFixedWidth()) {
            return dataType;
        }
        if (dataType.isCastableTo(PDecimal.INSTANCE)) {
            return PDecimal.INSTANCE;
        }
        if (dataType.isCoercibleTo(PVarchar.INSTANCE)) {
            return PVarchar.INSTANCE;
        }
        if (PBinary.INSTANCE.equals(dataType)) {
            return PVarbinary.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported non nullable index type " + dataType);
    }

    public static String getDataColumnName(String name) {
        return name.substring(name.indexOf(INDEX_COLUMN_NAME_SEP) + 1);
    }

    public static String getDataColumnFamilyName(String name) {
        return name.substring(0, name.indexOf(INDEX_COLUMN_NAME_SEP));
    }

    public static String getActualColumnFamilyName(String name) {
        if (name.startsWith("L#")) {
            return name.substring("L#".length());
        }
        return name;
    }

    public static String getCaseSensitiveDataColumnFullName(String name) {
        int index = name.indexOf(INDEX_COLUMN_NAME_SEP);
        return SchemaUtil.getCaseSensitiveColumnDisplayName(name.substring(0, index), name.substring(index + 1));
    }

    public static String getIndexColumnName(String dataColumnFamilyName, String dataColumnName) {
        return (dataColumnFamilyName == null ? "" : dataColumnFamilyName) + INDEX_COLUMN_NAME_SEP + dataColumnName;
    }

    public static byte[] getIndexColumnName(byte[] dataColumnFamilyName, byte[] dataColumnName) {
        return ByteUtil.concat(dataColumnFamilyName == null ? ByteUtil.EMPTY_BYTE_ARRAY : dataColumnFamilyName, INDEX_COLUMN_NAME_SEP_BYTES, dataColumnName);
    }

    public static String getIndexColumnName(PColumn dataColumn) {
        String dataColumnFamilyName = SchemaUtil.isPKColumn(dataColumn) ? null : dataColumn.getFamilyName().getString();
        return IndexUtil.getIndexColumnName(dataColumnFamilyName, dataColumn.getName().getString());
    }

    public static String getIndexColumnName(PColumn dataColumn, boolean isLocalIndex) {
        String dataColumnFamilyName = SchemaUtil.isPKColumn(dataColumn) ? null : dataColumn.getFamilyName().getString();
        return IndexUtil.getIndexColumnName(dataColumnFamilyName, dataColumn.getName().getString());
    }

    public static String getLocalIndexColumnFamily(String dataColumnFamilyName) {
        return dataColumnFamilyName == null ? null : "L#" + dataColumnFamilyName;
    }

    public static PColumn getDataColumn(PTable dataTable, String indexColumnName) {
        PColumnFamily family;
        int pos = indexColumnName.indexOf(INDEX_COLUMN_NAME_SEP);
        if (pos < 0) {
            throw new IllegalArgumentException("Could not find expected ':' separator in index column name of \"" + indexColumnName + "\"");
        }
        if (pos == 0) {
            try {
                return dataTable.getPKColumn(indexColumnName.substring(1));
            }
            catch (ColumnNotFoundException e) {
                throw new IllegalArgumentException("Could not find PK column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
            }
        }
        try {
            family = dataTable.getColumnFamily(IndexUtil.getDataColumnFamilyName(indexColumnName));
        }
        catch (ColumnFamilyNotFoundException e) {
            throw new IllegalArgumentException("Could not find column family \"" + indexColumnName.substring(0, pos) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
        try {
            return family.getColumn(indexColumnName.substring(pos + 1));
        }
        catch (ColumnNotFoundException e) {
            throw new IllegalArgumentException("Could not find column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
    }

    public static List<PColumn> getDataColumns(String dataTableName, List<PColumn> indexColumns, PhoenixConnection conn) throws SQLException {
        PTable dataTable = PhoenixRuntime.getTable(conn, dataTableName);
        ArrayList<PColumn> dataColumns = new ArrayList<PColumn>(indexColumns.size());
        for (PColumn indexColumn : indexColumns) {
            dataColumns.add(IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString()));
        }
        return dataColumns;
    }

    private static boolean isEmptyKeyValue(PTable table, ColumnReference ref) {
        byte[] emptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(table);
        return Bytes.compareTo(emptyKeyValueCF, 0, emptyKeyValueCF.length, ref.getFamilyWritable().get(), ref.getFamilyWritable().getOffset(), ref.getFamilyWritable().getLength()) == 0 && Bytes.compareTo(QueryConstants.EMPTY_COLUMN_BYTES, 0, QueryConstants.EMPTY_COLUMN_BYTES.length, ref.getQualifierWritable().get(), ref.getQualifierWritable().getOffset(), ref.getQualifierWritable().getLength()) == 0;
    }

    public static List<Mutation> generateIndexData(final PTable table, PTable index, List<Mutation> dataMutations, ImmutableBytesWritable ptr, final KeyValueBuilder kvBuilder, PhoenixConnection connection) throws SQLException {
        try {
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            ArrayList<Mutation> indexMutations = Lists.newArrayListWithExpectedSize(dataMutations.size());
            for (final Mutation dataMutation : dataMutations) {
                long ts = MetaDataUtil.getClientTimeStamp(dataMutation);
                ptr.set(dataMutation.getRow());
                if (!(dataMutation instanceof Put)) continue;
                ValueGetter valueGetter = new ValueGetter(){

                    @Override
                    public byte[] getRowKey() {
                        return dataMutation.getRow();
                    }

                    @Override
                    public ImmutableBytesPtr getLatestValue(ColumnReference ref) {
                        byte[] family;
                        if (IndexUtil.isEmptyKeyValue(table, ref)) {
                            return null;
                        }
                        NavigableMap<byte[], List<Cell>> familyMap = dataMutation.getFamilyCellMap();
                        List kvs = (List)familyMap.get(family = ref.getFamily());
                        if (kvs == null) {
                            return null;
                        }
                        byte[] qualifier = ref.getQualifier();
                        for (Cell kv : kvs) {
                            if (Bytes.compareTo(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), family, 0, family.length) != 0 || Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), qualifier, 0, qualifier.length) != 0) continue;
                            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                            kvBuilder.getValueAsPtr(kv, ptr);
                            return ptr;
                        }
                        return null;
                    }
                };
                byte[] regionStartKey = null;
                byte[] regionEndkey = null;
                if (maintainer.isLocalIndex()) {
                    HRegionLocation tableRegionLocation = connection.getQueryServices().getTableRegionLocation(table.getName().getBytes(), dataMutation.getRow());
                    regionStartKey = tableRegionLocation.getRegionInfo().getStartKey();
                    regionEndkey = tableRegionLocation.getRegionInfo().getEndKey();
                }
                indexMutations.add(maintainer.buildUpdateMutation(kvBuilder, valueGetter, ptr, ts, regionStartKey, regionEndkey));
            }
            return indexMutations;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isDataPKColumn(PColumn column) {
        return column.getName().getString().startsWith(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean isIndexColumn(String name) {
        return name.contains(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean getViewConstantValue(PColumn column, ImmutableBytesWritable ptr) {
        byte[] value = column.getViewConstant();
        if (value != null) {
            ptr.set(value, 0, value.length - 1);
            return true;
        }
        return false;
    }

    public static void setRowKeyExpressionOffset(Expression rootExpression, final int offset) {
        rootExpression.accept(new RowKeyExpressionVisitor(){

            @Override
            public Void visit(RowKeyColumnExpression node) {
                node.setOffset(offset);
                return null;
            }
        });
    }

    public static ColumnReference[] deserializeDataTableColumnsToJoin(Scan scan) {
        byte[] columnsBytes = scan.getAttribute("_DataTableColumnsToJoin");
        if (columnsBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(columnsBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numColumns = WritableUtils.readVInt(input);
            ColumnReference[] dataColumns = new ColumnReference[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                dataColumns[i] = new ColumnReference(Bytes.readByteArray(input), Bytes.readByteArray(input));
            }
            ColumnReference[] columnReferenceArray = dataColumns;
            return columnReferenceArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[][] deserializeViewConstantsFromScan(Scan scan) {
        byte[] bytes = scan.getAttribute("_ViewConstants");
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            int numConstants = WritableUtils.readVInt(input);
            byte[][] viewConstants = new byte[numConstants][];
            for (int i = 0; i < numConstants; ++i) {
                viewConstants[i] = Bytes.readByteArray(input);
            }
            byte[][] byArrayArray = viewConstants;
            return byArrayArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static KeyValueSchema deserializeLocalIndexJoinSchemaFromScan(Scan scan) {
        byte[] schemaBytes = scan.getAttribute("_LocalIndexJoinSchema");
        if (schemaBytes == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(schemaBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            KeyValueSchema schema = new KeyValueSchema();
            schema.readFields(input);
            KeyValueSchema keyValueSchema = schema;
            return keyValueSchema;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TupleProjector getTupleProjector(Scan scan, ColumnReference[] dataColumns) {
        if (dataColumns != null && dataColumns.length != 0) {
            KeyValueSchema keyValueSchema = IndexUtil.deserializeLocalIndexJoinSchemaFromScan(scan);
            Expression[] keyValueColumns = new KeyValueColumnExpression[dataColumns.length];
            for (int i = 0; i < dataColumns.length; ++i) {
                ColumnReference dataColumn = dataColumns[i];
                KeyValueColumnExpression dataColumnExpr = new KeyValueColumnExpression(keyValueSchema.getField(i), dataColumn.getFamily(), dataColumn.getQualifier());
                keyValueColumns[i] = dataColumnExpr;
            }
            return new TupleProjector(keyValueSchema, keyValueColumns);
        }
        return null;
    }

    public static String rewriteViewStatement(PhoenixConnection conn, PTable index, PTable table, String viewStatement) throws SQLException {
        if (viewStatement == null) {
            return null;
        }
        SelectStatement select = new SQLParser(viewStatement).parseQuery();
        ColumnResolver resolver = FromCompiler.getResolver(new TableRef(table));
        SelectStatement translatedSelect = IndexStatementRewriter.translate(select, resolver);
        ParseNode whereNode = translatedSelect.getWhere();
        PhoenixStatement statement = new PhoenixStatement(conn);
        TableRef indexTableRef = new TableRef(index){

            @Override
            public String getColumnDisplayName(ColumnRef ref, boolean schemaNameCaseSensitive, boolean colNameCaseSensitive) {
                return '\"' + ref.getColumn().getName().getString() + '\"';
            }
        };
        ColumnResolver indexResolver = FromCompiler.getResolver(indexTableRef);
        StatementContext context = new StatementContext(statement, indexResolver);
        WhereCompiler.compile(context, whereNode);
        StringBuilder buf = new StringBuilder();
        whereNode.toSQL(indexResolver, buf);
        return QueryUtil.getViewStatement(index.getSchemaName().getString(), index.getTableName().getString(), buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapResultUsingOffset(ObserverContext<RegionCoprocessorEnvironment> c, List<Cell> result, final int offset, ColumnReference[] dataColumns, TupleProjector tupleProjector, Region dataRegion, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr) throws IOException {
        if (tupleProjector != null) {
            Cell firstCell = result.get(0);
            byte[] indexRowKey = firstCell.getRowArray();
            ptr.set(indexRowKey, firstCell.getRowOffset() + offset, firstCell.getRowLength() - offset);
            byte[] dataRowKey = indexMaintainer.buildDataRowKey(ptr, viewConstants);
            Get get = new Get(dataRowKey);
            for (int i = 0; i < dataColumns.length; ++i) {
                get.addColumn(dataColumns[i].getFamily(), dataColumns[i].getQualifier());
            }
            Result joinResult = null;
            if (dataRegion != null) {
                joinResult = dataRegion.get(get);
            } else {
                TableName dataTable = TableName.valueOf(MetaDataUtil.getUserTableName(c.getEnvironment().getRegion().getTableDesc().getNameAsString()));
                try (HTableInterface table = null;){
                    table = c.getEnvironment().getTable(dataTable);
                    joinResult = table.get(get);
                }
            }
            ResultTuple joinTuple = new ResultTuple(joinResult);
            byte[] value = tupleProjector.getSchema().toBytes(joinTuple, tupleProjector.getExpressions(), tupleProjector.getValueBitSet(), ptr);
            KeyValue keyValue = KeyValueUtil.newKeyValue(firstCell.getRowArray(), firstCell.getRowOffset(), firstCell.getRowLength(), TupleProjector.VALUE_COLUMN_FAMILY, TupleProjector.VALUE_COLUMN_QUALIFIER, firstCell.getTimestamp(), value, 0, value.length);
            result.add(keyValue);
        }
        for (int i = 0; i < result.size(); ++i) {
            final Cell cell = result.get(i);
            Cell newCell = new Cell(){

                @Override
                public byte[] getRowArray() {
                    return cell.getRowArray();
                }

                @Override
                public int getRowOffset() {
                    return cell.getRowOffset() + offset;
                }

                @Override
                public short getRowLength() {
                    return (short)(cell.getRowLength() - offset);
                }

                @Override
                public byte[] getFamilyArray() {
                    return cell.getFamilyArray();
                }

                @Override
                public int getFamilyOffset() {
                    return cell.getFamilyOffset();
                }

                @Override
                public byte getFamilyLength() {
                    return cell.getFamilyLength();
                }

                @Override
                public byte[] getQualifierArray() {
                    return cell.getQualifierArray();
                }

                @Override
                public int getQualifierOffset() {
                    return cell.getQualifierOffset();
                }

                @Override
                public int getQualifierLength() {
                    return cell.getQualifierLength();
                }

                @Override
                public long getTimestamp() {
                    return cell.getTimestamp();
                }

                @Override
                public byte getTypeByte() {
                    return cell.getTypeByte();
                }

                @Override
                public long getMvccVersion() {
                    return cell.getMvccVersion();
                }

                @Override
                public long getSequenceId() {
                    return cell.getSequenceId();
                }

                @Override
                public byte[] getValueArray() {
                    return cell.getValueArray();
                }

                @Override
                public int getValueOffset() {
                    return cell.getValueOffset();
                }

                @Override
                public int getValueLength() {
                    return cell.getValueLength();
                }

                @Override
                public byte[] getTagsArray() {
                    return cell.getTagsArray();
                }

                @Override
                public int getTagsOffset() {
                    return cell.getTagsOffset();
                }

                @Override
                public int getTagsLength() {
                    return cell.getTagsLength();
                }

                @Override
                public byte[] getValue() {
                    return cell.getValue();
                }

                @Override
                public byte[] getFamily() {
                    return cell.getFamily();
                }

                @Override
                public byte[] getQualifier() {
                    return cell.getQualifier();
                }

                @Override
                public byte[] getRow() {
                    return cell.getRow();
                }
            };
            result.set(i, newCell);
        }
    }

    public static String getIndexColumnExpressionStr(PColumn col) {
        return col.getExpressionStr() == null ? IndexUtil.getCaseSensitiveDataColumnFullName(col.getName().getString()) : col.getExpressionStr();
    }
}

