/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.Timestamp;
import java.text.Format;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.util.DateUtil;

public class PUnsignedTimestamp
extends PDataType<Timestamp> {
    public static final PUnsignedTimestamp INSTANCE = new PUnsignedTimestamp();

    private PUnsignedTimestamp() {
        super("UNSIGNED_TIMESTAMP", 20, Timestamp.class, new PUnsignedDate.UnsignedDateCodec(), 12);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            throw PUnsignedTimestamp.newIllegalDataException(this + " may not be null");
        }
        byte[] bytes = new byte[this.getByteSize().intValue()];
        this.toBytes(object, bytes, 0);
        return bytes;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedTimestamp.newIllegalDataException(this + " may not be null");
        }
        Timestamp value = (Timestamp)object;
        PUnsignedDate.INSTANCE.getCodec().encodeLong(value.getTime(), bytes, offset);
        Bytes.putInt(bytes, offset + 8, value.getNanos() % 1000000);
        return this.getByteSize();
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Timestamp ts = (Timestamp)PTimestamp.INSTANCE.toObject(object, actualType);
        PUnsignedTimestamp.throwIfNonNegativeDate(ts);
        return ts;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Timestamp ts = (Timestamp)PTimestamp.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedTimestamp.throwIfNonNegativeDate(ts);
        return ts;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PUnsignedDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType.equals(this) || PUnsignedDate.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PTimestamp.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return PTimestamp.INSTANCE.getByteSize();
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PTimestamp.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public Object toObject(String value) {
        return PTimestamp.INSTANCE.toObject(value);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            formatter = DateUtil.DEFAULT_TIMESTAMP_FORMATTER;
        }
        return "'" + super.toStringLiteral(o, formatter) + "'";
    }

    @Override
    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        int nanos = PUnsignedInt.INSTANCE.getCodec().decodeInt(ptr.get(), ptr.getOffset() + PLong.INSTANCE.getByteSize(), sortOrder);
        return nanos;
    }

    @Override
    public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        long millis = PUnsignedLong.INSTANCE.getCodec().decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
        return millis;
    }

    @Override
    public int getResultSetSqlType() {
        return 93;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Timestamp((Long)PUnsignedLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }
}

