/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PRealNumber;
import org.apache.phoenix.schema.types.PUnsignedDouble;

public class PUnsignedFloat
extends PRealNumber<PFloat> {
    public static final PUnsignedFloat INSTANCE = new PUnsignedFloat();

    private PUnsignedFloat() {
        super("UNSIGNED_FLOAT", 14, Float.class, new UnsignedFloatCodec(), 19);
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PFloat.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 4;
    }

    @Override
    public Integer getScale(Object o) {
        return PFloat.INSTANCE.getScale(o);
    }

    @Override
    public Integer getMaxLength(Object o) {
        return PFloat.INSTANCE.getMaxLength(o);
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[4];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedFloat.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeFloat(((Number)object).floatValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Float f = Float.valueOf(Float.parseFloat(value));
            if (f.floatValue() < 0.0f) {
                throw PUnsignedFloat.newIllegalDataException("Value may not be negative(" + f + ")");
            }
            return f;
        }
        catch (NumberFormatException e) {
            throw PUnsignedFloat.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Float v = (Float)PFloat.INSTANCE.toObject(object, actualType);
        PUnsignedFloat.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Float v = (Float)PFloat.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedFloat.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType) || PFloat.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || PUnsignedDouble.INSTANCE.isCoercibleTo(targetType) || PFloat.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public int getResultSetSqlType() {
        return PFloat.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Float.valueOf(Math.abs(((Float)PFloat.INSTANCE.getSampleValue(maxLength, arrayLength)).floatValue()));
    }

    static class UnsignedFloatCodec
    extends PFloat.FloatCodec {
        UnsignedFloatCodec() {
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 4);
            if (v < 0.0f) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putFloat(b, o, v);
            return 4;
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            float v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 4);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[4], 0, 4);
            }
            if ((v = Bytes.toFloat(b, o)) < 0.0f) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }
    }
}

