/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.util.Date;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.DateUtil;

public class PTimestamp
extends PDataType<Timestamp> {
    public static final PTimestamp INSTANCE = new PTimestamp();

    private PTimestamp() {
        super("TIMESTAMP", 93, Timestamp.class, new PDate.DateCodec(), 9);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            throw PTimestamp.newIllegalDataException(this + " may not be null");
        }
        byte[] bytes = new byte[this.getByteSize().intValue()];
        this.toBytes(object, bytes, 0);
        return bytes;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PTimestamp.newIllegalDataException(this + " may not be null");
        }
        Timestamp value = (Timestamp)object;
        PDate.INSTANCE.getCodec().encodeLong(value.getTime(), bytes, offset);
        Bytes.putInt(bytes, offset + 8, value.getNanos() % 1000000);
        return this.getByteSize();
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PTimestamp.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            return new Timestamp(((Date)object).getTime());
        }
        if (PTimestamp.equalsAny(actualType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return object;
        }
        if (PTimestamp.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Timestamp((Long)object);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)object;
            long ms = bd.longValue();
            int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
            return DateUtil.getTimestamp(ms, nanos);
        }
        if (actualType == PVarchar.INSTANCE) {
            return DateUtil.parseTimestamp((String)object);
        }
        return PTimestamp.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Timestamp toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (actualType == null || l == 0) {
            return null;
        }
        if (PTimestamp.equalsAny(actualType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            long millisDeserialized = (actualType == INSTANCE ? PDate.INSTANCE : PUnsignedDate.INSTANCE).getCodec().decodeLong(b, o, sortOrder);
            Timestamp v = new Timestamp(millisDeserialized);
            int nanosDeserialized = PUnsignedInt.INSTANCE.getCodec().decodeInt(b, o + 8, sortOrder);
            v.setNanos(nanosDeserialized < 1000000 ? v.getNanos() + nanosDeserialized : nanosDeserialized);
            return v;
        }
        if (PTimestamp.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            return new Timestamp(actualType.getCodec().decodeLong(b, o, sortOrder));
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            long ms = bd.longValue();
            int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
            Timestamp v = DateUtil.getTimestamp(ms, nanos);
            return v;
        }
        PTimestamp.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PTimestamp.equalsAny(targetType, this, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (targetType.equals(PUnsignedTimestamp.INSTANCE)) {
                return ((Date)value).getTime() >= 0L;
            }
            if (PTimestamp.equalsAny(targetType, PUnsignedDate.INSTANCE, PUnsignedTime.INSTANCE)) {
                return ((Date)value).getTime() >= 0L && ((Timestamp)value).getNanos() == 0;
            }
            if (PTimestamp.equalsAny(targetType, PDate.INSTANCE, PTime.INSTANCE)) {
                return ((Timestamp)value).getNanos() == 0;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return MAX_TIMESTAMP_BYTES;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (PTimestamp.equalsAny(rhsType, INSTANCE, PUnsignedTimestamp.INSTANCE)) {
            return ((Timestamp)lhs).compareTo((Timestamp)rhs);
        }
        int c = ((Date)rhs).compareTo((Date)lhs);
        if (c != 0) {
            return c;
        }
        return ((Timestamp)lhs).getNanos();
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return DateUtil.parseTimestamp(value);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null) {
            formatter = DateUtil.DEFAULT_TIMESTAMP_FORMATTER;
        }
        return "'" + super.toStringLiteral(o, formatter) + "'";
    }

    @Override
    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        int nanos = PUnsignedInt.INSTANCE.getCodec().decodeInt(ptr.get(), ptr.getOffset() + PLong.INSTANCE.getByteSize(), sortOrder);
        return nanos;
    }

    @Override
    public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        long millis = PLong.INSTANCE.getCodec().decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
        return millis;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new Timestamp((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }
}

