/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class GuidePostsInfo {
    private List<byte[]> guidePosts;
    private long byteCount = 0L;
    private long rowCount = 0L;
    private long keyByteSize;

    public GuidePostsInfo(long byteCount, List<byte[]> guidePosts, long rowCount) {
        this.guidePosts = ImmutableList.copyOf(guidePosts);
        int size = 0;
        for (byte[] key : guidePosts) {
            size += key.length;
        }
        this.keyByteSize = size;
        this.byteCount = byteCount;
        this.rowCount = rowCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public List<byte[]> getGuidePosts() {
        return this.guidePosts;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void incrementRowCount() {
        ++this.rowCount;
    }

    public void combine(GuidePostsInfo oldInfo) {
        if (!oldInfo.getGuidePosts().isEmpty()) {
            byte[] newFirstKey = oldInfo.getGuidePosts().get(0);
            byte[] existingLastKey = !this.getGuidePosts().isEmpty() ? this.getGuidePosts().get(this.getGuidePosts().size() - 1) : HConstants.EMPTY_BYTE_ARRAY;
            int size = oldInfo.getGuidePosts().size();
            ArrayList<byte[]> newTotalGuidePosts = new ArrayList<byte[]>(this.getGuidePosts().size() + size);
            if (Bytes.compareTo(existingLastKey, newFirstKey) <= 0) {
                newTotalGuidePosts.addAll(this.getGuidePosts());
                newTotalGuidePosts.addAll(oldInfo.getGuidePosts());
            } else {
                newTotalGuidePosts.addAll(oldInfo.getGuidePosts());
                newTotalGuidePosts.addAll(this.getGuidePosts());
            }
            this.guidePosts = ImmutableList.copyOf(newTotalGuidePosts);
        }
        this.byteCount += oldInfo.getByteCount();
        this.keyByteSize += oldInfo.keyByteSize;
        this.rowCount += oldInfo.getRowCount();
    }

    public boolean addGuidePost(byte[] row, long byteCount) {
        if (this.guidePosts.isEmpty() || Bytes.compareTo(row, this.guidePosts.get(this.guidePosts.size() - 1)) > 0) {
            ArrayList<byte[]> newGuidePosts = Lists.newArrayListWithExpectedSize(this.getGuidePosts().size() + 1);
            newGuidePosts.addAll(this.guidePosts);
            newGuidePosts.add(row);
            this.guidePosts = ImmutableList.copyOf(newGuidePosts);
            this.byteCount += byteCount;
            this.keyByteSize += (long)row.length;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static GuidePostsInfo deserializeGuidePostsInfo(byte[] buf, int offset, int l, long rowCount) {
        try (ByteArrayInputStream bytesIn = new ByteArrayInputStream(buf, offset, l);){
            DataInputStream in = new DataInputStream(bytesIn);
            try {
                long byteCount = in.readLong();
                int guidepostsCount = in.readInt();
                ArrayList<byte[]> guidePosts = Lists.newArrayListWithExpectedSize(guidepostsCount);
                if (guidepostsCount > 0) {
                    for (int i = 0; i < guidepostsCount; ++i) {
                        int length = WritableUtils.readVInt(in);
                        byte[] gp = new byte[length];
                        in.read(gp);
                        if (gp.length == 0) continue;
                        guidePosts.add(gp);
                    }
                }
                GuidePostsInfo guidePostsInfo = new GuidePostsInfo(byteCount, guidePosts, rowCount);
                return guidePostsInfo;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serializeGuidePostsInfo() {
        int size = this.guidePosts.size();
        TrustedByteArrayOutputStream bs = new TrustedByteArrayOutputStream((int)(20L + this.keyByteSize + (long)(WritableUtils.getVIntSize(size) * size)));
        DataOutputStream os = new DataOutputStream(bs);
        try {
            os.writeLong(this.byteCount);
            os.writeInt(size);
            for (byte[] element : this.guidePosts) {
                WritableUtils.writeVInt(os, element.length);
                os.write(element);
            }
            Object object = bs.toByteArray();
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

