/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;

public class TableNotFoundException
extends MetaDataEntityNotFoundException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.TABLE_UNDEFINED;
    private final String schemaName;
    private final String tableName;
    private final long timestamp;

    public TableNotFoundException(TableNotFoundException e, long timestamp) {
        this(e.schemaName, e.tableName, timestamp);
    }

    public TableNotFoundException(String tableName) {
        this(null, tableName);
    }

    public TableNotFoundException(String schemaName, String tableName) {
        this(schemaName, tableName, Long.MAX_VALUE);
    }

    public TableNotFoundException(String schemaName, String tableName, long timestamp) {
        super(new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).build().toString(), code.getSQLState(), code.getErrorCode(), null);
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.timestamp = timestamp;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

