/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.MetaDataSplitPolicy;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.util.ByteUtil;

public interface QueryConstants {
    public static final String NAME_SEPARATOR = ".";
    public static final String NAME_SEPARATOR_REGEX = "\\.";
    public static final byte[] NAME_SEPARATOR_BYTES = Bytes.toBytes(".");
    public static final byte NAME_SEPARATOR_BYTE = NAME_SEPARATOR_BYTES[0];
    public static final String NULL_SCHEMA_NAME = "";
    public static final String NULL_DISPLAY_TEXT = "<null>";
    public static final long UNSET_TIMESTAMP = -1L;
    public static final String SYSTEM_SCHEMA_NAME = "SYSTEM";
    public static final byte[] SYSTEM_SCHEMA_NAME_BYTES = Bytes.toBytes("SYSTEM");
    public static final String PHOENIX_METADATA = "table";
    public static final PName SINGLE_COLUMN_NAME = PNameFactory.newNormalizedName("s");
    public static final PName SINGLE_COLUMN_FAMILY_NAME = PNameFactory.newNormalizedName("s");
    public static final byte[] SINGLE_COLUMN = SINGLE_COLUMN_NAME.getBytes();
    public static final byte[] SINGLE_COLUMN_FAMILY = SINGLE_COLUMN_FAMILY_NAME.getBytes();
    public static final long AGG_TIMESTAMP = Long.MAX_VALUE;
    public static final byte[] UNGROUPED_AGG_ROW_KEY = Bytes.toBytes("a");
    public static final PName AGG_COLUMN_NAME = SINGLE_COLUMN_NAME;
    public static final PName AGG_COLUMN_FAMILY_NAME = SINGLE_COLUMN_FAMILY_NAME;
    public static final byte[] ARRAY_VALUE_COLUMN_FAMILY = Bytes.toBytes("a");
    public static final byte[] ARRAY_VALUE_COLUMN_QUALIFIER = ByteUtil.EMPTY_BYTE_ARRAY;
    public static final byte[] TRUE = new byte[]{1};
    public static final byte SEPARATOR_BYTE = 0;
    public static final byte[] SEPARATOR_BYTE_ARRAY = new byte[]{0};
    public static final String DEFAULT_COPROCESS_PATH = "phoenix.jar";
    public static final int MILLIS_IN_DAY = 86400000;
    public static final String EMPTY_COLUMN_NAME = "_0";
    public static final byte[] EMPTY_COLUMN_BYTES = Bytes.toBytes("_0");
    public static final ImmutableBytesPtr EMPTY_COLUMN_BYTES_PTR = new ImmutableBytesPtr(EMPTY_COLUMN_BYTES);
    public static final String DEFAULT_COLUMN_FAMILY = "0";
    public static final byte[] DEFAULT_COLUMN_FAMILY_BYTES = Bytes.toBytes("0");
    public static final ImmutableBytesPtr DEFAULT_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_COLUMN_FAMILY_BYTES);
    public static final String LOCAL_INDEX_COLUMN_FAMILY_PREFIX = "L#";
    public static final byte[] LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES = Bytes.toBytes("L#");
    public static final ImmutableBytesPtr LOCAL_INDEX_COLUMN_FAMILY_PREFIX_PTR = new ImmutableBytesPtr(LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES);
    public static final String DEFAULT_LOCAL_INDEX_COLUMN_FAMILY = "L#0";
    public static final byte[] DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES = Bytes.toBytes("L#0");
    public static final ImmutableBytesPtr DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES_PTR = new ImmutableBytesPtr(DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
    public static final String ALL_FAMILY_PROPERTIES_KEY = "";
    public static final String SYSTEM_TABLE_PK_NAME = "pk";
    public static final double MILLIS_TO_NANOS_CONVERTOR = Math.pow(10.0, 6.0);
    public static final BigDecimal BD_MILLIS_NANOS_CONVERSION = BigDecimal.valueOf(MILLIS_TO_NANOS_CONVERTOR);
    public static final BigDecimal BD_MILLIS_IN_DAY = BigDecimal.valueOf(86400000L);
    public static final int MAX_ALLOWED_NANOS = 999999999;
    public static final int NANOS_IN_SECOND = BigDecimal.valueOf(Math.pow(10.0, 9.0)).intValue();
    public static final String CREATE_TABLE_METADATA = "CREATE TABLE SYSTEM.\"CATALOG\"(\nTENANT_ID VARCHAR NULL,TABLE_SCHEM VARCHAR NULL,TABLE_NAME VARCHAR NOT NULL,COLUMN_NAME VARCHAR NULL,COLUMN_FAMILY VARCHAR NULL,TABLE_SEQ_NUM BIGINT,TABLE_TYPE CHAR(1),PK_NAME VARCHAR,COLUMN_COUNT INTEGER,SALT_BUCKETS INTEGER,DATA_TABLE_NAME VARCHAR,INDEX_STATE CHAR(1),\nIMMUTABLE_ROWS BOOLEAN,\nVIEW_STATEMENT VARCHAR,\nDEFAULT_COLUMN_FAMILY VARCHAR,\nDISABLE_WAL BOOLEAN,\nMULTI_TENANT BOOLEAN,\nVIEW_TYPE UNSIGNED_TINYINT,\nVIEW_INDEX_ID SMALLINT,\nDATA_TYPE INTEGER,COLUMN_SIZE INTEGER,DECIMAL_DIGITS INTEGER,NULLABLE INTEGER,ORDINAL_POSITION INTEGER,SORT_ORDER INTEGER,ARRAY_SIZE INTEGER,\nVIEW_CONSTANT VARBINARY,\nIS_VIEW_REFERENCED BOOLEAN,\nKEY_SEQ SMALLINT,\nLINK_TYPE UNSIGNED_TINYINT,\nTYPE_NAME VARCHAR,REMARKS VARCHAR,SELF_REFERENCING_COL_NAME VARCHAR,REF_GENERATION VARCHAR,BUFFER_LENGTH INTEGER,NUM_PREC_RADIX INTEGER,COLUMN_DEF VARCHAR,SQL_DATA_TYPE INTEGER,SQL_DATETIME_SUB INTEGER,CHAR_OCTET_LENGTH INTEGER,IS_NULLABLE VARCHAR,SCOPE_CATALOG VARCHAR,SCOPE_SCHEMA VARCHAR,SCOPE_TABLE VARCHAR,SOURCE_DATA_TYPE SMALLINT,IS_AUTOINCREMENT VARCHAR,INDEX_TYPE UNSIGNED_TINYINT,INDEX_DISABLE_TIMESTAMP BIGINT,STORE_NULLS BOOLEAN,IS_ROW_TIMESTAMP BOOLEAN, CONSTRAINT pk PRIMARY KEY (TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "'\n";
    public static final String CREATE_STATS_TABLE_METADATA = "CREATE TABLE SYSTEM.\"STATS\"(\nPHYSICAL_NAME VARCHAR NOT NULL,COLUMN_FAMILY VARCHAR,REGION_NAME VARCHAR,GUIDE_POSTS_COUNT BIGINT,GUIDE_POSTS VARBINARY,GUIDE_POSTS_WIDTH BIGINT,MIN_KEY VARBINARY,MAX_KEY VARBINARY,LAST_STATS_UPDATE_TIME DATE, GUIDE_POSTS_ROW_COUNT BIGINT, CONSTRAINT pk PRIMARY KEY (PHYSICAL_NAME,COLUMN_FAMILY,REGION_NAME))\nVERSIONS=3,\nKEEP_DELETED_CELLS=true,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "'\n";
    public static final String CREATE_SEQUENCE_METADATA = "CREATE TABLE SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT, \nCURRENT_VALUE BIGINT, \nINCREMENT_BY BIGINT, \nCACHE_SIZE BIGINT, \nMIN_VALUE BIGINT, \nMAX_VALUE BIGINT, \nCYCLE_FLAG BOOLEAN, \nLIMIT_REACHED_FLAG BOOLEAN \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true\n";
    public static final String CREATE_FUNCTION_METADATA = "CREATE TABLE SYSTEM.\"FUNCTION\"(\nTENANT_ID VARCHAR NULL,FUNCTION_NAME VARCHAR NOT NULL, \nNUM_ARGS INTEGER, \nCLASS_NAME VARCHAR, \nJAR_PATH  VARCHAR, \nRETURN_TYPE VARCHAR, \nTYPE VARCHAR, \nARG_POSITION VARBINARY, \nIS_ARRAY BOOLEAN, \nIS_CONSTANT BOOLEAN, \nDEFAULT_VALUE VARCHAR, \nMIN_VALUE VARCHAR, \nMAX_VALUE VARCHAR, \n CONSTRAINT pk PRIMARY KEY (TENANT_ID, FUNCTION_NAME, TYPE, ARG_POSITION))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true,\nSPLIT_POLICY='" + MetaDataSplitPolicy.class.getName() + "'\n";

    public static enum JoinType {
        INNER,
        LEFT_OUTER;

    }
}

