/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.phoenix.monitoring.Counter;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.SizeStatistic;
import org.apache.phoenix.query.QueryServicesOptions;

public class PhoenixMetrics {
    private static final boolean isMetricsEnabled = QueryServicesOptions.withDefaults().isMetricsEnabled();

    public static boolean isMetricsEnabled() {
        return isMetricsEnabled;
    }

    public static Collection<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (SizeMetric sizeMetric : SizeMetric.values()) {
            metrics.add(sizeMetric.metric);
        }
        for (Enum enum_ : CountMetric.values()) {
            metrics.add(((CountMetric)enum_).metric);
        }
        return metrics;
    }

    public static enum CountMetric {
        MUTATION_COUNT("NumMutationCounter", "Counter for number of mutation statements"),
        QUERY_COUNT("NumQueryCounter", "Counter for number of queries"),
        TASK_COUNT("NumberOfTasksCounter", "Counter for number of tasks submitted to the thread pool executor"),
        REJECTED_TASK_COUNT("RejectedTasksCounter", "Counter for number of tasks that were rejected by the thread pool executor"),
        QUERY_TIMEOUT("QueryTimeoutCounter", "Number of times query timed out"),
        FAILED_QUERY("QueryFailureCounter", "Number of times query failed"),
        NUM_SPOOL_FILE("NumSpoolFilesCounter", "Number of spool files created");

        private final Counter metric;

        private CountMetric(String metricName, String metricDescription) {
            this.metric = new Counter(metricName, metricDescription);
        }

        public void increment() {
            if (isMetricsEnabled) {
                this.metric.increment();
            }
        }

        public Metric getMetric() {
            return this.metric;
        }

        public String toString() {
            return this.metric.toString();
        }
    }

    public static enum SizeMetric {
        MUTATION_BATCH_SIZE("CumulativeBatchSizesOfMutations", "Cumulative batch sizes of mutations"),
        MUTATION_BYTES("CumulativeMutationSize", "Cumulative size of mutations in bytes"),
        MUTATION_COMMIT_TIME("CumulativeMutationTime", "Cumulative time it took to send mutations"),
        QUERY_TIME("QueryTime", "Cumulative query times"),
        PARALLEL_SCANS("CumulativeNumberOfParallelScans", "Cumulative number of scans executed that were executed in parallel"),
        SCAN_BYTES("CumulativeScanBytesSize", "Cumulative number of bytes read by scans"),
        SPOOL_FILE_SIZE("CumulativeSpoolFilesSize", "Cumulative size of spool files created in bytes"),
        MEMORY_MANAGER_BYTES("CumulativeBytesAllocated", "Cumulative number of bytes allocated by the memory manager"),
        MEMORY_WAIT_TIME("CumulativeMemoryWaitTime", "Cumulative number of milliseconds threads needed to wait for memory to be allocated through memory manager"),
        TASK_QUEUE_WAIT_TIME("CumulativeTaskQueueWaitTime", "Cumulative time in milliseconds tasks had to wait in the queue of the thread pool executor"),
        TASK_END_TO_END_TIME("CumulativeTaskEndToEndTime", "Cumulative time in milliseconds spent by tasks from creation to completion"),
        TASK_EXECUTION_TIME("CumulativeTaskExecutionTime", "Cumulative time in milliseconds tasks took to execute");

        private final SizeStatistic metric;

        private SizeMetric(String metricName, String metricDescription) {
            this.metric = new SizeStatistic(metricName, metricDescription);
        }

        public void update(long value) {
            if (isMetricsEnabled) {
                this.metric.add(value);
            }
        }

        public Metric getMetric() {
            return this.metric;
        }

        public String toString() {
            return this.metric.toString();
        }
    }
}

