/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.join;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.HashCache;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ResultUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TupleUtil;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Snappy;

public class HashCacheFactory
implements ServerCachingProtocol.ServerCacheFactory {
    @Override
    public void readFields(DataInput input) throws IOException {
    }

    @Override
    public void write(DataOutput output) throws IOException {
    }

    @Override
    public Closeable newCache(ImmutableBytesWritable cachePtr, MemoryManager.MemoryChunk chunk) throws SQLException {
        try {
            int uncompressedLen = Snappy.getUncompressedLength(cachePtr.get(), cachePtr.getOffset());
            byte[] uncompressed = new byte[uncompressedLen];
            Snappy.uncompress(cachePtr.get(), cachePtr.getOffset(), cachePtr.getLength(), uncompressed, 0);
            return new HashCacheImpl(uncompressed, chunk);
        }
        catch (CorruptionException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Immutable
    private class HashCacheImpl
    implements HashCache {
        private final Map<ImmutableBytesPtr, List<Tuple>> hashCache;
        private final MemoryManager.MemoryChunk memoryChunk;
        private final boolean singleValueOnly;

        private HashCacheImpl(byte[] hashCacheBytes, MemoryManager.MemoryChunk memoryChunk) {
            try {
                this.memoryChunk = memoryChunk;
                byte[] hashCacheByteArray = hashCacheBytes;
                int offset = 0;
                ByteArrayInputStream input = new ByteArrayInputStream(hashCacheByteArray, offset, hashCacheBytes.length);
                DataInputStream dataInput = new DataInputStream(input);
                int nExprs = dataInput.readInt();
                ArrayList<Expression> onExpressions = new ArrayList<Expression>(nExprs);
                for (int i = 0; i < nExprs; ++i) {
                    int expressionOrdinal = WritableUtils.readVInt(dataInput);
                    Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                    expression.readFields(dataInput);
                    onExpressions.add(expression);
                }
                boolean singleValueOnly = false;
                int exprSizeAndSingleValueOnly = dataInput.readInt();
                int exprSize = exprSizeAndSingleValueOnly;
                if (exprSize < 0) {
                    exprSize *= -1;
                    singleValueOnly = true;
                }
                this.singleValueOnly = singleValueOnly;
                offset += exprSize;
                int nRows = dataInput.readInt();
                long estimatedSize = SizedUtil.sizeOfMap(nRows, 48, 88) + (long)hashCacheBytes.length;
                this.memoryChunk.resize(estimatedSize);
                HashMap<ImmutableBytesPtr, LinkedList<ResultTuple>> hashCacheMap = new HashMap<ImmutableBytesPtr, LinkedList<ResultTuple>>(nRows * 5 / 4);
                offset += 4;
                for (int i = 0; i < nRows; ++i) {
                    ImmutableBytesWritable value;
                    ResultTuple result;
                    ImmutableBytesPtr key;
                    LinkedList<ResultTuple> tuples;
                    int resultSize = (int)Bytes.readVLong(hashCacheByteArray, offset);
                    if ((tuples = (LinkedList<ResultTuple>)hashCacheMap.get(key = TupleUtil.getConcatenatedValue(result = new ResultTuple(ResultUtil.toResult(value = new ImmutableBytesWritable(hashCacheByteArray, offset += WritableUtils.decodeVIntSize(hashCacheByteArray[offset]), resultSize))), onExpressions))) == null) {
                        tuples = new LinkedList<ResultTuple>();
                        hashCacheMap.put(key, tuples);
                    }
                    tuples.add(result);
                    offset += resultSize;
                }
                this.hashCache = Collections.unmodifiableMap(hashCacheMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this.memoryChunk.close();
        }

        @Override
        public List<Tuple> get(ImmutableBytesPtr hashKey) throws IOException {
            List<Tuple> ret = this.hashCache.get(hashKey);
            if (this.singleValueOnly && ret != null && ret.size() > 1) {
                SQLException ex = new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                ServerUtil.throwIOException(ex.getMessage(), ex);
            }
            return ret;
        }
    }
}

