/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.Jdbc7Shim;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;

@Immutable
public abstract class PhoenixEmbeddedDriver
implements Driver,
Jdbc7Shim.Driver,
SQLCloseable {
    private static final String DNC_JDBC_PROTOCOL_SUFFIX = "//";
    private static final String DRIVER_NAME = "PhoenixEmbeddedDriver";
    private static final String TERMINATOR = ";";
    private static final String DELIMITERS = ";:";
    private static final String TEST_URL_AT_END = ";test=true";
    private static final String TEST_URL_IN_MIDDLE = ";test=true;";
    private static final DriverPropertyInfo[] EMPTY_INFO = new DriverPropertyInfo[0];
    public static final String MAJOR_VERSION_PROP = "DriverMajorVersion";
    public static final String MINOR_VERSION_PROP = "DriverMinorVersion";
    public static final String DRIVER_NAME_PROP = "DriverName";
    public static final ReadOnlyProps DEFFAULT_PROPS = new ReadOnlyProps(ImmutableMap.of("DriverMajorVersion", Integer.toString(4), "DriverMinorVersion", Integer.toString(4), "DriverName", "PhoenixEmbeddedDriver"));

    PhoenixEmbeddedDriver() {
    }

    protected ReadOnlyProps getDefaultProps() {
        return DEFFAULT_PROPS;
    }

    public abstract QueryServices getQueryServices();

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.startsWith("jdbc:phoenix")) {
            if (url.length() == "jdbc:phoenix".length()) {
                return true;
            }
            if (';' == url.charAt("jdbc:phoenix".length())) {
                return true;
            }
            if (':' == url.charAt("jdbc:phoenix".length())) {
                int protoLength = "jdbc:phoenix".length() + 1;
                if (url.length() == protoLength) {
                    return true;
                }
                if (url.startsWith("jdbc:phoenix:thin")) {
                    return false;
                }
                if (!url.startsWith(DNC_JDBC_PROTOCOL_SUFFIX, protoLength)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties augmentedInfo = PropertiesUtil.deepCopy(info);
        augmentedInfo.putAll(this.getDefaultProps().asMap());
        ConnectionQueryServices connectionServices = this.getConnectionQueryServices(url, augmentedInfo);
        PhoenixConnection connection = connectionServices.connect(url, augmentedInfo);
        return connection;
    }

    protected abstract ConnectionQueryServices getConnectionQueryServices(String var1, Properties var2) throws SQLException;

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_INFO;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public void close() throws SQLException {
    }

    public static boolean isTestUrl(String url) {
        return url.endsWith(TEST_URL_AT_END) || url.contains(TEST_URL_IN_MIDDLE);
    }

    public static class ConnectionInfo {
        private final Integer port;
        private final String rootNode;
        private final String zookeeperQuorum;
        private final boolean isConnectionless;
        private final String principal;
        private final String keytab;

        private static SQLException getMalFormedUrlException(String url) {
            return new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(url).build().buildException();
        }

        private static boolean isMultiPortUrl(String portStr) {
            int commaIndex = portStr.indexOf(44);
            if (commaIndex > 0) {
                try {
                    Integer.parseInt(portStr.substring(0, commaIndex));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public static ConnectionInfo create(String url) throws SQLException {
            url = url == null ? "" : url;
            url = url.startsWith("jdbc:phoenix") ? url.substring("jdbc:phoenix".length()) : ':' + url;
            StringTokenizer tokenizer = new StringTokenizer(url, PhoenixEmbeddedDriver.DELIMITERS, true);
            int nTokens = 0;
            String[] tokens = new String[5];
            String token = null;
            while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(PhoenixEmbeddedDriver.TERMINATOR) && tokenizer.hasMoreTokens() && nTokens < tokens.length) {
                token = tokenizer.nextToken();
                if (PhoenixEmbeddedDriver.DELIMITERS.contains(token)) {
                    throw ConnectionInfo.getMalFormedUrlException(url);
                }
                tokens[nTokens++] = token;
            }
            if (tokenizer.hasMoreTokens() && !PhoenixEmbeddedDriver.TERMINATOR.equals(token)) {
                throw ConnectionInfo.getMalFormedUrlException(url);
            }
            String quorum = null;
            Integer port = null;
            String rootNode = null;
            String principal = null;
            String keytabFile = null;
            int tokenIndex = 0;
            if (nTokens > tokenIndex) {
                quorum = tokens[tokenIndex++];
                if (nTokens > tokenIndex) {
                    block12: {
                        try {
                            port = Integer.parseInt(tokens[tokenIndex]);
                            if (port < 0) {
                                throw ConnectionInfo.getMalFormedUrlException(url);
                            }
                            ++tokenIndex;
                        }
                        catch (NumberFormatException e) {
                            if (!ConnectionInfo.isMultiPortUrl(tokens[tokenIndex])) break block12;
                            throw ConnectionInfo.getMalFormedUrlException(url);
                        }
                    }
                    if (nTokens > tokenIndex) {
                        if (tokens[tokenIndex].startsWith("/")) {
                            rootNode = tokens[tokenIndex++];
                        }
                        if (nTokens > tokenIndex) {
                            principal = tokens[tokenIndex++];
                            if (nTokens > tokenIndex) {
                                keytabFile = tokens[tokenIndex++];
                            }
                        }
                    }
                }
            }
            return new ConnectionInfo(quorum, port, rootNode, principal, keytabFile);
        }

        public ConnectionInfo normalize(ReadOnlyProps props) throws SQLException {
            String zookeeperQuorum = this.getZookeeperQuorum();
            Integer port = this.getPort();
            String rootNode = this.getRootNode();
            String keytab = this.getKeytab();
            String principal = this.getPrincipal();
            if (zookeeperQuorum == null && (zookeeperQuorum = props.get("hbase.zookeeper.quorum")) == null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(this.toString()).build().buildException();
            }
            if (port == null) {
                String portStr;
                if (!this.isConnectionless && (portStr = props.get("hbase.zookeeper.property.clientPort")) != null) {
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(this.toString()).build().buildException();
                    }
                }
            } else if (this.isConnectionless) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage("Port may not be specified when using the connectionless url \"" + this.toString() + "\"").build().buildException();
            }
            if (rootNode == null) {
                if (!this.isConnectionless) {
                    rootNode = props.get("zookeeper.znode.parent");
                }
            } else if (this.isConnectionless) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage("Root node may not be specified when using the connectionless url \"" + this.toString() + "\"").build().buildException();
            }
            if (principal == null && !this.isConnectionless) {
                principal = props.get("hbase.myclient.principal");
            }
            if (keytab == null && !this.isConnectionless) {
                keytab = props.get("hbase.myclient.keytab");
            }
            return new ConnectionInfo(zookeeperQuorum, port, rootNode, principal, keytab);
        }

        public ConnectionInfo(String zookeeperQuorum, Integer port, String rootNode, String principal, String keytab) {
            this.zookeeperQuorum = zookeeperQuorum;
            this.port = port;
            this.rootNode = rootNode;
            this.isConnectionless = "none".equals(zookeeperQuorum);
            this.principal = principal;
            this.keytab = keytab;
        }

        public ConnectionInfo(String zookeeperQuorum, Integer port, String rootNode) {
            this(zookeeperQuorum, port, rootNode, null, null);
        }

        public ReadOnlyProps asProps() {
            HashMap<String, String> connectionProps = Maps.newHashMapWithExpectedSize(3);
            if (this.getZookeeperQuorum() != null) {
                connectionProps.put("hbase.zookeeper.quorum", this.getZookeeperQuorum());
            }
            if (this.getPort() != null) {
                connectionProps.put("hbase.zookeeper.property.clientPort", this.getPort().toString());
            }
            if (this.getRootNode() != null) {
                connectionProps.put("zookeeper.znode.parent", this.getRootNode());
            }
            if (this.getPrincipal() != null && this.getKeytab() != null) {
                connectionProps.put("hbase.myclient.principal", this.getPrincipal());
                connectionProps.put("hbase.myclient.keytab", this.getKeytab());
            }
            return connectionProps.isEmpty() ? ReadOnlyProps.EMPTY_PROPS : new ReadOnlyProps(connectionProps.entrySet().iterator());
        }

        public boolean isConnectionless() {
            return this.isConnectionless;
        }

        public String getZookeeperQuorum() {
            return this.zookeeperQuorum;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getRootNode() {
            return this.rootNode;
        }

        public String getKeytab() {
            return this.keytab;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.zookeeperQuorum == null ? 0 : this.zookeeperQuorum.hashCode());
            result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
            result = 31 * result + (this.rootNode == null ? 0 : this.rootNode.hashCode());
            result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
            result = 31 * result + (this.keytab == null ? 0 : this.keytab.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)obj;
            if (this.zookeeperQuorum == null ? other.zookeeperQuorum != null : !this.zookeeperQuorum.equals(other.zookeeperQuorum)) {
                return false;
            }
            if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
                return false;
            }
            if (this.rootNode == null ? other.rootNode != null : !this.rootNode.equals(other.rootNode)) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            return !(this.keytab == null ? other.keytab != null : !this.keytab.equals(other.keytab));
        }

        public String toString() {
            return this.zookeeperQuorum + (this.port == null ? "" : ":" + this.port) + (this.rootNode == null ? "" : ":" + this.rootNode) + (this.principal == null ? "" : ":" + this.principal) + (this.keytab == null ? "" : ":" + this.keytab);
        }

        public String toUrl() {
            return "jdbc:phoenix:" + this.toString();
        }
    }
}

