/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesImpl;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixDriver
extends PhoenixEmbeddedDriver {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixDriver.class);
    public static final PhoenixDriver INSTANCE;
    private static volatile String driverShutdownMsg;
    private final ConcurrentMap<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> connectionQueryServicesMap = new ConcurrentHashMap<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices>(3);
    private volatile QueryServices services;
    @GuardedBy(value="closeLock")
    private volatile boolean closed = false;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();

    private static void closeInstance(PhoenixDriver instance) {
        try {
            instance.close();
        }
        catch (SQLException e) {
            logger.warn("Unable to close PhoenixDriver on shutdown", e);
        }
        finally {
            driverShutdownMsg = "Phoenix driver closed because server is shutting down";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryServices getQueryServices() {
        try {
            SQLCloseable sQLCloseable;
            this.closeLock.readLock().lock();
            this.checkClosed();
            QueryServices result = this.services;
            if (result == null) {
                sQLCloseable = this;
                synchronized (sQLCloseable) {
                    result = this.services;
                    if (result == null) {
                        this.services = result = new QueryServicesImpl(this.getDefaultProps());
                    }
                }
            }
            sQLCloseable = result;
            return sQLCloseable;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return super.acceptsURL(url) && !PhoenixDriver.isTestUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            this.closeLock.readLock().lock();
            this.checkClosed();
            Connection connection = super.connect(url, info);
            return connection;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConnectionQueryServices getConnectionQueryServices(String url, Properties info) throws SQLException {
        try {
            ConnectionQueryServices connectionQueryServices;
            block23: {
                ConnectionQueryServices prevValue;
                this.closeLock.readLock().lock();
                this.checkClosed();
                PhoenixEmbeddedDriver.ConnectionInfo connInfo = PhoenixEmbeddedDriver.ConnectionInfo.create(url);
                QueryServices services = this.getQueryServices();
                PhoenixEmbeddedDriver.ConnectionInfo normalizedConnInfo = connInfo.normalize(services.getProps());
                connectionQueryServices = (ConnectionQueryServices)this.connectionQueryServicesMap.get(normalizedConnInfo);
                if (connectionQueryServices == null && (prevValue = this.connectionQueryServicesMap.putIfAbsent(normalizedConnInfo, connectionQueryServices = normalizedConnInfo.isConnectionless() ? new ConnectionlessQueryServicesImpl(services, normalizedConnInfo) : new ConnectionQueryServicesImpl(services, normalizedConnInfo, info))) != null) {
                    connectionQueryServices = prevValue;
                }
                boolean success = false;
                SQLException sqlE = null;
                try {
                    connectionQueryServices.init(url, info);
                    success = true;
                }
                catch (SQLException e) {
                    sqlE = e;
                    return sqlE;
                }
                finally {
                    if (success) break block23;
                    try {
                        connectionQueryServices.close();
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        this.connectionQueryServicesMap.remove(normalizedConnInfo);
                        if (sqlE == null) break block23;
                        throw sqlE;
                    }
                }
            }
            ConnectionQueryServices connectionQueryServices2 = connectionQueryServices;
            return connectionQueryServices2;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private void checkClosed() {
        if (this.closed) {
            this.throwDriverClosedException();
        }
    }

    private void throwDriverClosedException() {
        throw new IllegalStateException(driverShutdownMsg != null ? driverShutdownMsg : "The Phoenix jdbc driver has been closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.closeLock.writeLock().lock();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        try {
            Collection connectionQueryServices = this.connectionQueryServicesMap.values();
            try {
                SQLCloseables.closeAll(connectionQueryServices);
            }
            finally {
                connectionQueryServices.clear();
            }
        }
        finally {
            if (this.services != null) {
                try {
                    this.services.close();
                }
                finally {
                    ThreadPoolExecutor executor = this.services.getExecutor();
                    this.services = null;
                    executor.shutdown();
                }
            }
        }
    }

    static {
        try {
            INSTANCE = new PhoenixDriver();
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        PhoenixDriver.closeInstance(INSTANCE);
                    }
                });
                DriverManager.registerDriver(INSTANCE);
            }
            catch (IllegalStateException e) {
                logger.warn("Failed to register PhoenixDriver shutdown hook as the JVM is already shutting down");
                PhoenixDriver.closeInstance(INSTANCE);
                throw e;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to register " + PhoenixDriver.class.getName() + ": " + e.getMessage());
        }
    }
}

