/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ServerUtil;

public class TableResultIterator
extends ExplainTable
implements ResultIterator {
    private final Scan scan;
    private final HTableInterface htable;
    private volatile ResultIterator delegate;

    public TableResultIterator(StatementContext context, TableRef tableRef) throws SQLException {
        this(context, tableRef, context.getScan());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultIterator getDelegate(boolean isClosing) throws SQLException {
        ResultIterator delegate = this.delegate;
        if (delegate == null) {
            TableResultIterator tableResultIterator = this;
            synchronized (tableResultIterator) {
                delegate = this.delegate;
                if (delegate == null) {
                    try {
                        delegate = isClosing ? ResultIterator.EMPTY_ITERATOR : new ScanningResultIterator(this.htable.getScanner(this.scan));
                        this.delegate = delegate;
                    }
                    catch (IOException e) {
                        Closeables.closeQuietly(this.htable);
                        throw ServerUtil.parseServerException(e);
                    }
                }
            }
        }
        return delegate;
    }

    public TableResultIterator(StatementContext context, TableRef tableRef, Scan scan) throws SQLException {
        this(context, tableRef, scan, ScannerCreation.IMMEDIATE);
    }

    public TableResultIterator(StatementContext context, TableRef tableRef, Scan scan, ScannerCreation creationMode) throws SQLException {
        super(context, tableRef);
        this.scan = scan;
        this.htable = context.getConnection().getQueryServices().getTable(tableRef.getTable().getPhysicalName().getBytes());
        if (creationMode == ScannerCreation.IMMEDIATE) {
            this.getDelegate(false);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.getDelegate(true).close();
        }
        finally {
            try {
                this.htable.close();
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
    }

    @Override
    public Tuple next() throws SQLException {
        return this.getDelegate(false).next();
    }

    @Override
    public void explain(List<String> planSteps) {
        StringBuilder buf = new StringBuilder();
        this.explain(buf.toString(), planSteps);
    }

    public String toString() {
        return "TableResultIterator [htable=" + this.htable + ", scan=" + this.scan + "]";
    }

    public static enum ScannerCreation {
        IMMEDIATE,
        DELAYED;

    }
}

