/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.monitoring.PhoenixMetrics;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class ScanningResultIterator
implements ResultIterator {
    private final ResultScanner scanner;

    public ScanningResultIterator(ResultScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void close() throws SQLException {
        this.scanner.close();
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            Result result = this.scanner.next();
            ScanningResultIterator.calculateScanSize(result);
            return result == null ? null : new ResultTuple(result);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    public String toString() {
        return "ScanningResultIterator [scanner=" + this.scanner + "]";
    }

    private static void calculateScanSize(Result result) {
        if (PhoenixMetrics.isMetricsEnabled() && result != null) {
            Cell[] cells = result.rawCells();
            long scanResultSize = 0L;
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                scanResultSize += kv.heapSize();
            }
            PhoenixMetrics.SizeMetric.SCAN_BYTES.update(scanResultSize);
        }
    }
}

